/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.drivers.auxelex.LambdaPS;
import org.lsst.ccs.drivers.auxelex.SA56004;
import org.lsst.ccs.drivers.auxelex.Srp;
import org.lsst.ccs.drivers.commons.DriverException;

public class RebBulkPS
extends Srp {
    public static final int FIRST_BULK = 1;
    public static final int NUM_BULKS = 5;
    public static final int IOSTAT_REM_ON = 1;
    public static final int IOSTAT_ENABLED = 2;
    public static final int IOSTAT_AC_OK = 4;
    public static final int IOSTAT_PWR_OK = 8;
    public static final int IOSTAT_OTW = 16;
    protected static final int REG_LAMBDA_BASE = 131072;
    protected static final int LAMBDA_INCREMENT = 1024;
    protected static final int REG_LAMBDA_IO = 137216;
    private static final List<Srp.BoardType> validTypes = new ArrayList<Srp.BoardType>();
    private final LambdaPS[] lambda = new LambdaPS[5];
    private final SA56004 temp;

    public RebBulkPS() {
        this.setValidBoardTypes(validTypes);
        for (int j = 0; j < 5; ++j) {
            this.lambda[j] = new LambdaPS(this, 131072 + (j + 1) * 1024, 2);
        }
        this.temp = new SA56004(this);
    }

    public void setPowerOn(int id, boolean on) throws DriverException {
        this.writeReg(137217 + this.checkBulkId(id), on ? 1 : 0);
    }

    public int getIoStatus(int id) throws DriverException {
        return this.readReg(137217 + this.checkBulkId(id));
    }

    public double readBoardTemperature() throws DriverException {
        return this.temp.readTemperature();
    }

    public int getModel(int id) throws DriverException {
        return this.lambda[this.checkBulkId(id)].getModel();
    }

    public String getSerialNo(int id) throws DriverException {
        return this.lambda[this.checkBulkId(id)].getSerialNo();
    }

    public String getFwVersion(int id) throws DriverException {
        return this.lambda[this.checkBulkId(id)].getFwVersion();
    }

    public String getPrVersion(int id) throws DriverException {
        return this.lambda[this.checkBulkId(id)].getPrVersion();
    }

    public String getPartNo(int id) throws DriverException {
        return this.lambda[this.checkBulkId(id)].getPartNo();
    }

    public String getManuDate(int id) throws DriverException {
        return this.lambda[this.checkBulkId(id)].getManuDate();
    }

    public String getManuLocn(int id) throws DriverException {
        return this.lambda[this.checkBulkId(id)].getManuLocn();
    }

    public int readStatus(int id) throws DriverException {
        return this.lambda[this.checkBulkId(id)].readStatus();
    }

    public double readVoltage(int id) throws DriverException {
        return this.lambda[this.checkBulkId(id)].readVoltage();
    }

    public double readCurrent(int id) throws DriverException {
        return this.lambda[this.checkBulkId(id)].readCurrent();
    }

    public double readTemperature(int id) throws DriverException {
        return this.lambda[this.checkBulkId(id)].readTemperature();
    }

    private int checkBulkId(int id) throws DriverException {
        if (id < 0 || id >= 5) {
            throw new DriverException("Invalid power supply ID: " + id);
        }
        return id;
    }

    @Override
    protected void simInitialize() {
        super.simInitialize();
        for (int j = 0; j < 5; ++j) {
            this.lambda[j].simInitialize();
        }
        this.temp.simInitialize();
    }

    @Override
    protected void simWriteRegs(int addr, int[] value, int count) {
        int j = 0;
        while (j < count) {
            this.putSimRegMap(addr, value[j]);
            int id = addr - 137216 - 1;
            if (id >= 0 && id < 5) {
                this.lambda[id].simSetOutput(value[j] != 0);
            }
            ++j;
            ++addr;
        }
    }

    static {
        validTypes.add(Srp.BoardType.HEATER);
        validTypes.add(Srp.BoardType.SIMULATED);
    }
}

