/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.utility.FanPIControl;
import org.lsst.ccs.subsystem.utility.PurgeMaq20Device;
import org.lsst.ccs.subsystem.utility.SwitchControl;
import org.lsst.ccs.subsystem.utility.VpcControl;
import org.lsst.ccs.subsystem.utility.constants.FanState;
import org.lsst.ccs.subsystem.utility.constants.HeaterState;
import org.lsst.ccs.subsystem.utility.constants.UTPurgeFans;
import org.lsst.ccs.subsystem.utility.constants.UTPurgeHeaters;
import org.lsst.ccs.subsystem.utility.constants.UTPurgeValves;
import org.lsst.ccs.subsystem.utility.constants.ValveState;
import org.lsst.ccs.subsystem.utility.constants.VpcControlState;
import org.lsst.ccs.subsystem.utility.data.UTPurgeState;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class UTPurgeMain
extends Subsystem
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(UTPurgeMain.class.getName());
    @LookupName
    String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final List<SwitchControl> swDeviceList = new ArrayList<SwitchControl>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final Map<String, FanPIControl> fanDeviceMap = new LinkedHashMap<String, FanPIControl>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private VpcControl vpcControl;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private PurgeMaq20Device purgeControl;
    private String mpcFan;
    private String vpcFan;
    private String utFan;
    private final UTPurgeState purgeState = new UTPurgeState();
    private final FanPIControl[] fanControl = new FanPIControl[3];

    public UTPurgeMain() {
        super("purgetest", AgentInfo.AgentType.WORKER);
    }

    public void build() {
        AgentPeriodicTask pt = new AgentPeriodicTask("UT-state", () -> this.updateState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        this.propertiesService.setAgentProperty("utPurgeType", ((Object)((Object)this)).getClass().getCanonicalName());
        if (this.mpcFan != null) {
            this.fanControl[0] = this.fanDeviceMap.get(this.mpcFan);
        }
        if (this.fanControl[0] == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"mpcFan", (String)"not specified or not defined");
        }
        if (this.vpcFan != null) {
            this.fanControl[1] = this.fanDeviceMap.get(this.vpcFan);
        }
        if (this.fanControl[1] == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"vpcFan", (String)"not specified or not defined");
        }
        if (this.utFan != null) {
            this.fanControl[2] = this.fanDeviceMap.get(this.utFan);
        }
        if (this.fanControl[2] == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"utFan", (String)"not specified or not defined");
        }
        if (this.vpcControl == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"VpcControl", (String)"has not been defined");
        }
        if (this.purgeControl == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"PurgeMaq20Device", (String)"has not been defined");
        }
        this.purgeState.setHeaterValue(0, this.vpcControl.getDeltaTemp(0));
        this.purgeState.setHeaterValue(1, this.vpcControl.getDeltaTemp(1));
    }

    public void postStart() {
        LOG.info("Purge test subsystem started");
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full state")
    public UTPurgeState getFullState() {
        this.purgeState.setTickMillis(this.getTickPeriod());
        return this.purgeState;
    }

    @Command(type=Command.CommandType.QUERY, description="Get list of fan names")
    public List<String> getFanNames() {
        return new ArrayList<String>(UTPurgeFans.fanNameToId.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Command(type=Command.CommandType.ACTION, description="Set a fan control state")
    public void setFanState(@Argument(description="The fan name") String name, @Argument(description="The control state") FanState state) throws UtilityException {
        int fanId;
        block13: {
            fanId = this.getFanId(name);
            if (state == FanState.OFFLINE) throw new UtilityException("Invalid " + name + " state: " + state);
            if (state == FanState.TEMP && !UTPurgeFans.hasTempState[fanId]) {
                throw new UtilityException("Invalid " + name + " state: " + state);
            }
            UTPurgeState uTPurgeState = this.purgeState;
            // MONITORENTER : uTPurgeState
            if (state != this.purgeState.getFanBaseState(fanId)) break block13;
            // MONITOREXIT : uTPurgeState
            this.publishState();
            return;
        }
        this.purgeState.setFanBaseState(fanId, state);
        if (this.purgeState.getFanState(fanId) == FanState.OFFLINE) {
            // MONITOREXIT : uTPurgeState
            this.publishState();
            return;
        }
        try {
            this.purgeState.setFanState(fanId, state);
            FanPIControl ctrlr = this.fanControl[fanId];
            if (state == FanState.TEMP) {
                ctrlr.setTemperature(this.purgeState.getDeltaTemp(fanId));
                ctrlr.startLoop(this.purgeState.getFanSpeed(fanId));
                return;
            }
            if (UTPurgeFans.hasTempState[fanId]) {
                ctrlr.stopLoop();
            }
            if (state == FanState.SPEED) {
                ctrlr.setSpeed(this.purgeState.getFanSpeed(fanId));
            }
            // MONITOREXIT : uTPurgeState
            return;
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a fan speed")
    public void setFanSpeed(@Argument(description="The fan name") String name, @Argument(description="The fan speed") double speed) throws UtilityException {
        try {
            int fanId = this.getFanId(name);
            UTPurgeState uTPurgeState = this.purgeState;
            synchronized (uTPurgeState) {
                this.purgeState.setFanSpeed(fanId, speed);
                if (this.purgeState.getFanState(fanId) == FanState.SPEED) {
                    this.fanControl[fanId].setSpeed(speed);
                }
            }
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set the VPC control state")
    public void setVpcState(@Argument(description="The control state") VpcControlState state) throws UtilityException {
        try {
            UTPurgeState uTPurgeState = this.purgeState;
            synchronized (uTPurgeState) {
                block14: {
                    if (state != this.purgeState.getVpcState()) break block14;
                    return;
                }
                this.purgeState.setVpcState(state);
                HeaterState h1State = this.purgeState.getHeaterState(0);
                HeaterState h2State = this.purgeState.getHeaterState(1);
                if (state == VpcControlState.TEMP) {
                    if (h1State != HeaterState.OFFLINE) {
                        this.purgeState.setHeaterState(0, HeaterState.TEMP);
                    }
                    if (h2State != HeaterState.OFFLINE) {
                        this.purgeState.setHeaterState(1, HeaterState.TEMP);
                    }
                    this.vpcControl.startLoop();
                } else {
                    this.vpcControl.stopLoop();
                    if (h1State != HeaterState.OFFLINE) {
                        this.purgeState.setHeaterState(0, this.purgeState.getHeaterBaseState(0));
                        this.operateHeater(0);
                    }
                    if (h2State != HeaterState.OFFLINE) {
                        this.purgeState.setHeaterState(1, this.purgeState.getHeaterBaseState(1));
                        this.operateHeater(1);
                    }
                }
            }
        }
        finally {
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get list of valve names")
    public List<String> getValveNames() {
        return new ArrayList<String>(UTPurgeValves.valveNameToId.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Command(type=Command.CommandType.ACTION, description="Set a valve control state")
    public void setValveState(@Argument(description="The valve name") String name, @Argument(description="The control state") ValveState state) throws UtilityException {
        int valveId;
        block10: {
            valveId = this.getValveId(name);
            if (state == ValveState.OFFLINE) throw new UtilityException("Invalid " + name + " state: " + state);
            if (state == ValveState.TEMP) {
                throw new UtilityException("Invalid " + name + " state: " + state);
            }
            UTPurgeState uTPurgeState = this.purgeState;
            // MONITORENTER : uTPurgeState
            if (state != this.purgeState.getValveBaseState(valveId)) break block10;
            // MONITOREXIT : uTPurgeState
            this.publishState();
            return;
        }
        this.purgeState.setValveBaseState(valveId, state);
        ValveState currState = this.purgeState.getValveState(valveId);
        if (currState == ValveState.OFFLINE || currState == ValveState.TEMP) {
            // MONITOREXIT : uTPurgeState
            this.publishState();
            return;
        }
        try {
            this.purgeState.setValveState(valveId, state);
            this.operateValve(valveId);
            // MONITOREXIT : uTPurgeState
            return;
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a valve position")
    public void setValvePosition(@Argument(description="The valve name") String name, @Argument(description="The valve position") double position) throws UtilityException {
        try {
            int valveId = this.getValveId(name);
            UTPurgeState uTPurgeState = this.purgeState;
            synchronized (uTPurgeState) {
                this.purgeState.setValvePosition(valveId, position);
                if (this.purgeState.getValveState(valveId) == ValveState.POSN) {
                    this.operateValve(valveId);
                }
            }
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a delta temperature")
    public void setFanDeltaTemp(@Argument(description="The fan name") String name, @Argument(description="The delta temperature") double temp) throws UtilityException {
        try {
            int fanId = this.getFanId(name);
            UTPurgeState uTPurgeState = this.purgeState;
            synchronized (uTPurgeState) {
                this.purgeState.setDeltaTemp(fanId, temp);
                if (this.purgeState.getFanState(fanId) == FanState.TEMP && fanId != 1) {
                    this.fanControl[fanId].setTemperature(temp);
                }
            }
        }
        finally {
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get list of heater names")
    public List<String> getHeaterNames() {
        return new ArrayList<String>(UTPurgeHeaters.heaterNameToId.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Command(type=Command.CommandType.ACTION, description="Set a heater control state")
    public void setHeaterState(@Argument(description="The heater name") String name, @Argument(description="The control state") HeaterState state) throws UtilityException {
        int htrId;
        block10: {
            htrId = this.getHeaterId(name);
            if (state == HeaterState.OFFLINE) throw new UtilityException("Invalid " + name + " state: " + state);
            if (state == HeaterState.TEMP) {
                throw new UtilityException("Invalid " + name + " state: " + state);
            }
            UTPurgeState uTPurgeState = this.purgeState;
            // MONITORENTER : uTPurgeState
            if (state != this.purgeState.getHeaterBaseState(htrId)) break block10;
            // MONITOREXIT : uTPurgeState
            this.publishState();
            return;
        }
        this.purgeState.setHeaterBaseState(htrId, state);
        HeaterState currState = this.purgeState.getHeaterState(htrId);
        if (currState == HeaterState.OFFLINE || currState == HeaterState.TEMP) {
            // MONITOREXIT : uTPurgeState
            this.publishState();
            return;
        }
        try {
            this.purgeState.setHeaterState(htrId, state);
            this.operateHeater(htrId);
            // MONITOREXIT : uTPurgeState
            return;
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a heater power")
    public void setHeaterValue(@Argument(description="The heater name") String name, @Argument(description="The value") double value) throws UtilityException {
        try {
            int htrId = this.getHeaterId(name);
            UTPurgeState uTPurgeState = this.purgeState;
            synchronized (uTPurgeState) {
                this.purgeState.setHeaterValue(htrId, value);
                if (htrId == 2) {
                    this.operateHeater(htrId);
                } else if (this.purgeState.getHeaterState(htrId) == HeaterState.TEMP) {
                    this.vpcControl.setDeltaTemp(htrId, value);
                }
            }
        }
        finally {
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update period")
    public void setUpdatePeriod(@Argument(name="period", description="The tick period (msecs)") int period) {
        this.setTickPeriod(period);
        this.publishState();
    }

    private void operateHeater(int htrId) throws UtilityException {
        HeaterState state = this.purgeState.getHeaterState(htrId);
        if (state == HeaterState.OFFLINE || state == HeaterState.TEMP) {
            return;
        }
        if (htrId == 2 && state == HeaterState.ON) {
            this.purgeControl.setSimHeater(this.purgeState.getHeaterValue(htrId));
        }
    }

    private void operateValve(int valveId) throws UtilityException {
        double position;
        ValveState state = this.purgeState.getValveState(valveId);
        if (state == ValveState.OFFLINE || state == ValveState.TEMP) {
            return;
        }
        double d = position = state == ValveState.SHUT ? 0.0 : this.purgeState.getValvePosition(valveId);
        if (valveId == 0) {
            this.purgeControl.setUtValve(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState() {
        UTPurgeState uTPurgeState = this.purgeState;
        synchronized (uTPurgeState) {
            Boolean st;
            int sw;
            boolean changed = false;
            for (int fan = 0; fan < 3; ++fan) {
                FanState fs;
                sw = (Integer)UTPurgeFans.fanSwitchMap.get(fan);
                st = true;
                FanState fanState = st == null ? FanState.OFFLINE : (fs = st == false ? FanState.OFF : this.purgeState.getFanBaseState(fan));
                if (fs == this.purgeState.getFanState(fan)) continue;
                if (fs != FanState.OFFLINE) {
                    this.purgeState.setFanBaseState(fan, fs);
                }
                this.purgeState.setFanState(fan, fs);
                FanPIControl ctrlr = this.fanControl[fan];
                if (ctrlr != null && fs == FanState.SPEED) {
                    ctrlr.setSpeed(this.purgeState.getFanSpeed(fan));
                }
                changed = true;
            }
            for (int htr = 0; htr < 3; ++htr) {
                HeaterState hs;
                sw = (Integer)UTPurgeHeaters.heaterSwitchMap.get(htr);
                st = true;
                HeaterState heaterState = st == null ? HeaterState.OFFLINE : (UTPurgeHeaters.hasAutoState[htr] && this.purgeState.getVpcState() == VpcControlState.TEMP ? HeaterState.TEMP : (hs = st != false ? HeaterState.ON : HeaterState.OFF));
                if (hs == this.purgeState.getHeaterState(htr)) continue;
                if (hs != HeaterState.TEMP && hs != HeaterState.OFFLINE) {
                    this.purgeState.setHeaterBaseState(htr, hs);
                }
                this.purgeState.setHeaterState(htr, hs);
                try {
                    this.operateHeater(htr);
                }
                catch (UtilityException e) {
                    LOG.log(Level.SEVERE, "Error operating heater {0}: {1}", new Object[]{htr, e});
                }
                changed = true;
            }
            for (int valve = 0; valve < 1; ++valve) {
                ValveState vs;
                ValveState valveState = !this.purgeControl.isOnline() ? ValveState.OFFLINE : (vs = UTPurgeValves.hasTempState[valve] && this.purgeState.getVpcState() == VpcControlState.TEMP ? ValveState.TEMP : this.purgeState.getValveBaseState(valve));
                if (vs == this.purgeState.getValveState(valve)) continue;
                this.purgeState.setValveState(valve, vs);
                try {
                    this.operateValve(valve);
                }
                catch (UtilityException e) {
                    LOG.log(Level.SEVERE, "Error operating valve {0}: {1}", new Object[]{valve, e});
                }
                changed = true;
            }
            if (changed) {
                this.publishState();
            }
        }
    }

    private void setTickPeriod(long period) {
        this.periodicTaskService.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.periodicTaskService.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    private void publishState() {
        this.purgeState.setTickMillis(this.getTickPeriod());
        this.publishSubsystemDataOnStatusBus(new KeyValueData("UTPurgeState", (Serializable)this.purgeState));
    }

    private int getFanId(String name) throws UtilityException {
        Integer id = (Integer)UTPurgeFans.fanNameToId.get(name);
        if (id == null) {
            throw new UtilityException("Invalid fan name: " + name);
        }
        return id;
    }

    private int getValveId(String name) throws UtilityException {
        Integer id = (Integer)UTPurgeValves.valveNameToId.get(name);
        if (id == null) {
            throw new UtilityException("Invalid valve name: " + name);
        }
        return id;
    }

    private int getHeaterId(String name) throws UtilityException {
        Integer id = (Integer)UTPurgeHeaters.heaterNameToId.get(name);
        if (id == null) {
            throw new UtilityException("Invalid heater name: " + name);
        }
        return id;
    }
}

