/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.parsers;

import java.io.CharConversionException;
import java.io.IOException;
import java.util.Locale;
import org.python.apache.xerces.parsers.AbstractXMLDocumentParser;
import org.python.apache.xerces.parsers.XML11Configurable;
import org.python.apache.xerces.util.EntityResolver2Wrapper;
import org.python.apache.xerces.util.EntityResolverWrapper;
import org.python.apache.xerces.util.ErrorHandlerWrapper;
import org.python.apache.xerces.util.SAXMessageFormatter;
import org.python.apache.xerces.util.SymbolHash;
import org.python.apache.xerces.util.XMLSymbols;
import org.python.apache.xerces.xni.Augmentations;
import org.python.apache.xerces.xni.NamespaceContext;
import org.python.apache.xerces.xni.QName;
import org.python.apache.xerces.xni.XMLAttributes;
import org.python.apache.xerces.xni.XMLLocator;
import org.python.apache.xerces.xni.XMLResourceIdentifier;
import org.python.apache.xerces.xni.XMLString;
import org.python.apache.xerces.xni.XNIException;
import org.python.apache.xerces.xni.parser.XMLConfigurationException;
import org.python.apache.xerces.xni.parser.XMLEntityResolver;
import org.python.apache.xerces.xni.parser.XMLErrorHandler;
import org.python.apache.xerces.xni.parser.XMLInputSource;
import org.python.apache.xerces.xni.parser.XMLParseException;
import org.python.apache.xerces.xni.parser.XMLParserConfiguration;
import org.python.apache.xerces.xs.AttributePSVI;
import org.python.apache.xerces.xs.ElementPSVI;
import org.python.apache.xerces.xs.PSVIProvider;
import org.xml.sax.AttributeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.ext.Locator2Impl;

public abstract class AbstractSAXParser
extends AbstractXMLDocumentParser
implements PSVIProvider,
Parser,
XMLReader {
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String STRING_INTERNING = "http://xml.org/sax/features/string-interning";
    protected static final String ALLOW_UE_AND_NOTATION_EVENTS = "http://xml.org/sax/features/allow-dtd-events-after-endDTD";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/namespaces", "http://xml.org/sax/features/string-interning"};
    protected static final String LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    protected static final String DECLARATION_HANDLER = "http://xml.org/sax/properties/declaration-handler";
    protected static final String DOM_NODE = "http://xml.org/sax/properties/dom-node";
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://xml.org/sax/properties/lexical-handler", "http://xml.org/sax/properties/declaration-handler", "http://xml.org/sax/properties/dom-node"};
    protected boolean fNamespaces;
    protected boolean fNamespacePrefixes = false;
    protected boolean fLexicalHandlerParameterEntities = true;
    protected boolean fStandalone;
    protected boolean fResolveDTDURIs = true;
    protected boolean fUseEntityResolver2 = true;
    protected boolean fXMLNSURIs = false;
    protected ContentHandler fContentHandler;
    protected DocumentHandler fDocumentHandler;
    protected NamespaceContext fNamespaceContext;
    protected DTDHandler fDTDHandler;
    protected DeclHandler fDeclHandler;
    protected LexicalHandler fLexicalHandler;
    protected final QName fQName = new QName();
    protected boolean fParseInProgress = false;
    protected String fVersion;
    private final AttributesProxy fAttributesProxy = new AttributesProxy();
    private Augmentations fAugmentations = null;
    protected SymbolHash fDeclaredAttrs = null;

    protected AbstractSAXParser(XMLParserConfiguration xMLParserConfiguration) {
        super(xMLParserConfiguration);
        xMLParserConfiguration.addRecognizedFeatures(RECOGNIZED_FEATURES);
        xMLParserConfiguration.addRecognizedProperties(RECOGNIZED_PROPERTIES);
        try {
            xMLParserConfiguration.setFeature(ALLOW_UE_AND_NOTATION_EVENTS, false);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    public void startDocument(XMLLocator xMLLocator, String string2, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fNamespaceContext = namespaceContext;
        try {
            if (this.fDocumentHandler != null) {
                if (xMLLocator != null) {
                    this.fDocumentHandler.setDocumentLocator(new LocatorProxy(xMLLocator));
                }
                if (this.fDocumentHandler != null) {
                    this.fDocumentHandler.startDocument();
                }
            }
            if (this.fContentHandler != null) {
                if (xMLLocator != null) {
                    this.fContentHandler.setDocumentLocator(new LocatorProxy(xMLLocator));
                }
                if (this.fContentHandler != null) {
                    this.fContentHandler.startDocument();
                }
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void xmlDecl(String string2, String string3, String string4, Augmentations augmentations) throws XNIException {
        this.fVersion = string2;
        this.fStandalone = "yes".equals(string4);
    }

    public void doctypeDecl(String string2, String string3, String string4, Augmentations augmentations) throws XNIException {
        this.fInDTD = true;
        try {
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.startDTD(string2, string3, string4);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
        if (this.fDeclHandler != null) {
            this.fDeclaredAttrs = new SymbolHash();
        }
    }

    public void startGeneralEntity(String string2, XMLResourceIdentifier xMLResourceIdentifier, String string3, Augmentations augmentations) throws XNIException {
        try {
            if (augmentations != null && Boolean.TRUE.equals(augmentations.getItem("ENTITY_SKIPPED"))) {
                if (this.fContentHandler != null) {
                    this.fContentHandler.skippedEntity(string2);
                }
            } else if (this.fLexicalHandler != null) {
                this.fLexicalHandler.startEntity(string2);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void endGeneralEntity(String string2, Augmentations augmentations) throws XNIException {
        try {
            if (!(augmentations != null && Boolean.TRUE.equals(augmentations.getItem("ENTITY_SKIPPED")) || this.fLexicalHandler == null)) {
                this.fLexicalHandler.endEntity(string2);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        block11: {
            try {
                if (this.fDocumentHandler != null) {
                    this.fAttributesProxy.setAttributes(xMLAttributes);
                    this.fDocumentHandler.startElement(qName.rawname, this.fAttributesProxy);
                }
                if (this.fContentHandler == null) break block11;
                if (this.fNamespaces) {
                    int n;
                    this.startNamespaceMapping();
                    int n2 = xMLAttributes.getLength();
                    if (!this.fNamespacePrefixes) {
                        n = n2 - 1;
                        while (n >= 0) {
                            xMLAttributes.getName(n, this.fQName);
                            if (this.fQName.prefix == XMLSymbols.PREFIX_XMLNS || this.fQName.rawname == XMLSymbols.PREFIX_XMLNS) {
                                xMLAttributes.removeAttributeAt(n);
                            }
                            --n;
                        }
                    } else if (!this.fXMLNSURIs) {
                        n = n2 - 1;
                        while (n >= 0) {
                            xMLAttributes.getName(n, this.fQName);
                            if (this.fQName.prefix == XMLSymbols.PREFIX_XMLNS || this.fQName.rawname == XMLSymbols.PREFIX_XMLNS) {
                                this.fQName.prefix = "";
                                this.fQName.uri = "";
                                this.fQName.localpart = "";
                                xMLAttributes.setName(n, this.fQName);
                            }
                            --n;
                        }
                    }
                }
                this.fAugmentations = augmentations;
                String string2 = qName.uri != null ? qName.uri : "";
                String string3 = this.fNamespaces ? qName.localpart : "";
                this.fAttributesProxy.setAttributes(xMLAttributes);
                this.fContentHandler.startElement(string2, string3, qName.rawname, this.fAttributesProxy);
            }
            catch (SAXException sAXException) {
                throw new XNIException(sAXException);
            }
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (xMLString.length == 0) {
            return;
        }
        try {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.characters(xMLString.ch, xMLString.offset, xMLString.length);
            }
            if (this.fContentHandler != null) {
                this.fContentHandler.characters(xMLString.ch, xMLString.offset, xMLString.length);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        try {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.ignorableWhitespace(xMLString.ch, xMLString.offset, xMLString.length);
            }
            if (this.fContentHandler != null) {
                this.fContentHandler.ignorableWhitespace(xMLString.ch, xMLString.offset, xMLString.length);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        try {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.endElement(qName.rawname);
            }
            if (this.fContentHandler != null) {
                this.fAugmentations = augmentations;
                String string2 = qName.uri != null ? qName.uri : "";
                String string3 = this.fNamespaces ? qName.localpart : "";
                this.fContentHandler.endElement(string2, string3, qName.rawname);
                if (this.fNamespaces) {
                    this.endNamespaceMapping();
                }
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        try {
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.startCDATA();
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        try {
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.endCDATA();
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        try {
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.comment(xMLString.ch, 0, xMLString.length);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void processingInstruction(String string2, XMLString xMLString, Augmentations augmentations) throws XNIException {
        try {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.processingInstruction(string2, xMLString.toString());
            }
            if (this.fContentHandler != null) {
                this.fContentHandler.processingInstruction(string2, xMLString.toString());
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        try {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.endDocument();
            }
            if (this.fContentHandler != null) {
                this.fContentHandler.endDocument();
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void startExternalSubset(XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        this.startParameterEntity("[dtd]", null, null, augmentations);
    }

    public void endExternalSubset(Augmentations augmentations) throws XNIException {
        this.endParameterEntity("[dtd]", augmentations);
    }

    public void startParameterEntity(String string2, XMLResourceIdentifier xMLResourceIdentifier, String string3, Augmentations augmentations) throws XNIException {
        try {
            if (augmentations != null && Boolean.TRUE.equals(augmentations.getItem("ENTITY_SKIPPED"))) {
                if (this.fContentHandler != null) {
                    this.fContentHandler.skippedEntity(string2);
                }
            } else if (this.fLexicalHandler != null && this.fLexicalHandlerParameterEntities) {
                this.fLexicalHandler.startEntity(string2);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void endParameterEntity(String string2, Augmentations augmentations) throws XNIException {
        try {
            if ((augmentations == null || !Boolean.TRUE.equals(augmentations.getItem("ENTITY_SKIPPED"))) && this.fLexicalHandler != null && this.fLexicalHandlerParameterEntities) {
                this.fLexicalHandler.endEntity(string2);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void elementDecl(String string2, String string3, Augmentations augmentations) throws XNIException {
        try {
            if (this.fDeclHandler != null) {
                this.fDeclHandler.elementDecl(string2, string3);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void attributeDecl(String string2, String string3, String string4, String[] stringArray, String string5, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
        try {
            if (this.fDeclHandler != null) {
                CharSequence charSequence;
                String string6 = string2 + '<' + string3;
                if (this.fDeclaredAttrs.get(string6) != null) {
                    return;
                }
                this.fDeclaredAttrs.put(string6, Boolean.TRUE);
                if (string4.equals("NOTATION") || string4.equals("ENUMERATION")) {
                    charSequence = new StringBuffer();
                    if (string4.equals("NOTATION")) {
                        ((StringBuffer)charSequence).append(string4);
                        ((StringBuffer)charSequence).append(" (");
                    } else {
                        ((StringBuffer)charSequence).append('(');
                    }
                    int n = 0;
                    while (n < stringArray.length) {
                        ((StringBuffer)charSequence).append(stringArray[n]);
                        if (n < stringArray.length - 1) {
                            ((StringBuffer)charSequence).append('|');
                        }
                        ++n;
                    }
                    ((StringBuffer)charSequence).append(')');
                    string4 = ((StringBuffer)charSequence).toString();
                }
                charSequence = xMLString == null ? null : xMLString.toString();
                this.fDeclHandler.attributeDecl(string2, string3, string4, string5, (String)charSequence);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void internalEntityDecl(String string2, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
        try {
            if (this.fDeclHandler != null) {
                this.fDeclHandler.internalEntityDecl(string2, xMLString.toString());
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void externalEntityDecl(String string2, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        try {
            if (this.fDeclHandler != null) {
                String string3 = xMLResourceIdentifier.getPublicId();
                String string4 = this.fResolveDTDURIs ? xMLResourceIdentifier.getExpandedSystemId() : xMLResourceIdentifier.getLiteralSystemId();
                this.fDeclHandler.externalEntityDecl(string2, string3, string4);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void unparsedEntityDecl(String string2, XMLResourceIdentifier xMLResourceIdentifier, String string3, Augmentations augmentations) throws XNIException {
        try {
            if (this.fDTDHandler != null) {
                String string4 = xMLResourceIdentifier.getPublicId();
                String string5 = this.fResolveDTDURIs ? xMLResourceIdentifier.getExpandedSystemId() : xMLResourceIdentifier.getLiteralSystemId();
                this.fDTDHandler.unparsedEntityDecl(string2, string4, string5, string3);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void notationDecl(String string2, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        try {
            if (this.fDTDHandler != null) {
                String string3 = xMLResourceIdentifier.getPublicId();
                String string4 = this.fResolveDTDURIs ? xMLResourceIdentifier.getExpandedSystemId() : xMLResourceIdentifier.getLiteralSystemId();
                this.fDTDHandler.notationDecl(string2, string3, string4);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void endDTD(Augmentations augmentations) throws XNIException {
        this.fInDTD = false;
        try {
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.endDTD();
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
        if (this.fDeclaredAttrs != null) {
            this.fDeclaredAttrs.clear();
        }
    }

    public void parse(String string2) throws SAXException, IOException {
        XMLInputSource xMLInputSource = new XMLInputSource(null, string2, null);
        try {
            this.parse(xMLInputSource);
        }
        catch (XMLParseException xMLParseException) {
            Exception exception = xMLParseException.getException();
            if (exception == null || exception instanceof CharConversionException) {
                Locator2Impl locator2Impl = new Locator2Impl();
                locator2Impl.setXMLVersion(this.fVersion);
                locator2Impl.setPublicId(xMLParseException.getPublicId());
                locator2Impl.setSystemId(xMLParseException.getExpandedSystemId());
                locator2Impl.setLineNumber(xMLParseException.getLineNumber());
                locator2Impl.setColumnNumber(xMLParseException.getColumnNumber());
                throw exception == null ? new SAXParseException(xMLParseException.getMessage(), locator2Impl) : new SAXParseException(xMLParseException.getMessage(), locator2Impl, exception);
            }
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new SAXException(exception);
        }
        catch (XNIException xNIException) {
            Exception exception = xNIException.getException();
            if (exception == null) {
                throw new SAXException(xNIException.getMessage());
            }
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new SAXException(exception);
        }
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        try {
            XMLInputSource xMLInputSource = new XMLInputSource(inputSource.getPublicId(), inputSource.getSystemId(), null);
            xMLInputSource.setByteStream(inputSource.getByteStream());
            xMLInputSource.setCharacterStream(inputSource.getCharacterStream());
            xMLInputSource.setEncoding(inputSource.getEncoding());
            this.parse(xMLInputSource);
        }
        catch (XMLParseException xMLParseException) {
            Exception exception = xMLParseException.getException();
            if (exception == null || exception instanceof CharConversionException) {
                Locator2Impl locator2Impl = new Locator2Impl();
                locator2Impl.setXMLVersion(this.fVersion);
                locator2Impl.setPublicId(xMLParseException.getPublicId());
                locator2Impl.setSystemId(xMLParseException.getExpandedSystemId());
                locator2Impl.setLineNumber(xMLParseException.getLineNumber());
                locator2Impl.setColumnNumber(xMLParseException.getColumnNumber());
                throw exception == null ? new SAXParseException(xMLParseException.getMessage(), locator2Impl) : new SAXParseException(xMLParseException.getMessage(), locator2Impl, exception);
            }
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new SAXException(exception);
        }
        catch (XNIException xNIException) {
            Exception exception = xNIException.getException();
            if (exception == null) {
                throw new SAXException(xNIException.getMessage());
            }
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new SAXException(exception);
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        try {
            XMLEntityResolver xMLEntityResolver = (XMLEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
            if (this.fUseEntityResolver2 && entityResolver instanceof EntityResolver2) {
                if (xMLEntityResolver instanceof EntityResolver2Wrapper) {
                    EntityResolver2Wrapper entityResolver2Wrapper = (EntityResolver2Wrapper)xMLEntityResolver;
                    entityResolver2Wrapper.setEntityResolver((EntityResolver2)entityResolver);
                } else {
                    this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new EntityResolver2Wrapper((EntityResolver2)entityResolver));
                }
            } else if (xMLEntityResolver instanceof EntityResolverWrapper) {
                EntityResolverWrapper entityResolverWrapper = (EntityResolverWrapper)xMLEntityResolver;
                entityResolverWrapper.setEntityResolver(entityResolver);
            } else {
                this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new EntityResolverWrapper(entityResolver));
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    public EntityResolver getEntityResolver() {
        EntityResolver entityResolver = null;
        try {
            XMLEntityResolver xMLEntityResolver = (XMLEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
            if (xMLEntityResolver != null) {
                if (xMLEntityResolver instanceof EntityResolverWrapper) {
                    entityResolver = ((EntityResolverWrapper)xMLEntityResolver).getEntityResolver();
                } else if (xMLEntityResolver instanceof EntityResolver2Wrapper) {
                    entityResolver = ((EntityResolver2Wrapper)xMLEntityResolver).getEntityResolver();
                }
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        return entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        try {
            XMLErrorHandler xMLErrorHandler = (XMLErrorHandler)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/error-handler");
            if (xMLErrorHandler instanceof ErrorHandlerWrapper) {
                ErrorHandlerWrapper errorHandlerWrapper = (ErrorHandlerWrapper)xMLErrorHandler;
                errorHandlerWrapper.setErrorHandler(errorHandler);
            } else {
                this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/error-handler", new ErrorHandlerWrapper(errorHandler));
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    public ErrorHandler getErrorHandler() {
        ErrorHandler errorHandler = null;
        try {
            XMLErrorHandler xMLErrorHandler = (XMLErrorHandler)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/error-handler");
            if (xMLErrorHandler != null && xMLErrorHandler instanceof ErrorHandlerWrapper) {
                errorHandler = ((ErrorHandlerWrapper)xMLErrorHandler).getErrorHandler();
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        return errorHandler;
    }

    public void setLocale(Locale locale2) throws SAXException {
        this.fConfiguration.setLocale(locale2);
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.fDTDHandler = dTDHandler;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.fDocumentHandler = documentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.fContentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.fContentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    public void setFeature(String string2, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            if (string2.startsWith("http://xml.org/sax/features/")) {
                int n = string2.length() - "http://xml.org/sax/features/".length();
                if (n == "namespaces".length() && string2.endsWith("namespaces")) {
                    this.fConfiguration.setFeature(string2, bl);
                    this.fNamespaces = bl;
                    return;
                }
                if (n == "namespace-prefixes".length() && string2.endsWith("namespace-prefixes")) {
                    this.fNamespacePrefixes = bl;
                    return;
                }
                if (n == "string-interning".length() && string2.endsWith("string-interning")) {
                    if (!bl) {
                        throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "false-not-supported", new Object[]{string2}));
                    }
                    return;
                }
                if (n == "lexical-handler/parameter-entities".length() && string2.endsWith("lexical-handler/parameter-entities")) {
                    this.fLexicalHandlerParameterEntities = bl;
                    return;
                }
                if (n == "resolve-dtd-uris".length() && string2.endsWith("resolve-dtd-uris")) {
                    this.fResolveDTDURIs = bl;
                    return;
                }
                if (n == "unicode-normalization-checking".length() && string2.endsWith("unicode-normalization-checking")) {
                    if (bl) {
                        throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "true-not-supported", new Object[]{string2}));
                    }
                    return;
                }
                if (n == "xmlns-uris".length() && string2.endsWith("xmlns-uris")) {
                    this.fXMLNSURIs = bl;
                    return;
                }
                if (n == "use-entity-resolver2".length() && string2.endsWith("use-entity-resolver2")) {
                    if (bl != this.fUseEntityResolver2) {
                        this.fUseEntityResolver2 = bl;
                        this.setEntityResolver(this.getEntityResolver());
                    }
                    return;
                }
                if (n == "is-standalone".length() && string2.endsWith("is-standalone") || n == "use-attributes2".length() && string2.endsWith("use-attributes2") || n == "use-locator2".length() && string2.endsWith("use-locator2") || n == "xml-1.1".length() && string2.endsWith("xml-1.1")) {
                    throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "feature-read-only", new Object[]{string2}));
                }
            }
            this.fConfiguration.setFeature(string2, bl);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string3 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "feature-not-recognized", new Object[]{string3}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "feature-not-supported", new Object[]{string3}));
        }
    }

    public boolean getFeature(String string2) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            if (string2.startsWith("http://xml.org/sax/features/")) {
                int n = string2.length() - "http://xml.org/sax/features/".length();
                if (n == "namespace-prefixes".length() && string2.endsWith("namespace-prefixes")) {
                    return this.fNamespacePrefixes;
                }
                if (n == "string-interning".length() && string2.endsWith("string-interning")) {
                    return true;
                }
                if (n == "is-standalone".length() && string2.endsWith("is-standalone")) {
                    return this.fStandalone;
                }
                if (n == "xml-1.1".length() && string2.endsWith("xml-1.1")) {
                    return this.fConfiguration instanceof XML11Configurable;
                }
                if (n == "lexical-handler/parameter-entities".length() && string2.endsWith("lexical-handler/parameter-entities")) {
                    return this.fLexicalHandlerParameterEntities;
                }
                if (n == "resolve-dtd-uris".length() && string2.endsWith("resolve-dtd-uris")) {
                    return this.fResolveDTDURIs;
                }
                if (n == "xmlns-uris".length() && string2.endsWith("xmlns-uris")) {
                    return this.fXMLNSURIs;
                }
                if (n == "unicode-normalization-checking".length() && string2.endsWith("unicode-normalization-checking")) {
                    return false;
                }
                if (n == "use-entity-resolver2".length() && string2.endsWith("use-entity-resolver2")) {
                    return this.fUseEntityResolver2;
                }
                if (n == "use-attributes2".length() && string2.endsWith("use-attributes2") || n == "use-locator2".length() && string2.endsWith("use-locator2")) {
                    return true;
                }
            }
            return this.fConfiguration.getFeature(string2);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string3 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "feature-not-recognized", new Object[]{string3}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "feature-not-supported", new Object[]{string3}));
        }
    }

    public void setProperty(String string2, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            if (string2.startsWith("http://xml.org/sax/properties/")) {
                int n = string2.length() - "http://xml.org/sax/properties/".length();
                if (n == "lexical-handler".length() && string2.endsWith("lexical-handler")) {
                    try {
                        this.setLexicalHandler((LexicalHandler)object);
                    }
                    catch (ClassCastException classCastException) {
                        throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "incompatible-class", new Object[]{string2, "org.xml.sax.ext.LexicalHandler"}));
                    }
                    return;
                }
                if (n == "declaration-handler".length() && string2.endsWith("declaration-handler")) {
                    try {
                        this.setDeclHandler((DeclHandler)object);
                    }
                    catch (ClassCastException classCastException) {
                        throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "incompatible-class", new Object[]{string2, "org.xml.sax.ext.DeclHandler"}));
                    }
                    return;
                }
                if (n == "dom-node".length() && string2.endsWith("dom-node") || n == "document-xml-version".length() && string2.endsWith("document-xml-version")) {
                    throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-read-only", new Object[]{string2}));
                }
            }
            this.fConfiguration.setProperty(string2, object);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string3 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-not-recognized", new Object[]{string3}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-not-supported", new Object[]{string3}));
        }
    }

    public Object getProperty(String string2) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            if (string2.startsWith("http://xml.org/sax/properties/")) {
                int n = string2.length() - "http://xml.org/sax/properties/".length();
                if (n == "document-xml-version".length() && string2.endsWith("document-xml-version")) {
                    return this.fVersion;
                }
                if (n == "lexical-handler".length() && string2.endsWith("lexical-handler")) {
                    return this.getLexicalHandler();
                }
                if (n == "declaration-handler".length() && string2.endsWith("declaration-handler")) {
                    return this.getDeclHandler();
                }
                if (n == "dom-node".length() && string2.endsWith("dom-node")) {
                    throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "dom-node-read-not-supported", null));
                }
            }
            return this.fConfiguration.getProperty(string2);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string3 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-not-recognized", new Object[]{string3}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-not-supported", new Object[]{string3}));
        }
    }

    protected void setDeclHandler(DeclHandler declHandler) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-not-parsing-supported", new Object[]{DECLARATION_HANDLER}));
        }
        this.fDeclHandler = declHandler;
    }

    protected DeclHandler getDeclHandler() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fDeclHandler;
    }

    protected void setLexicalHandler(LexicalHandler lexicalHandler) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-not-parsing-supported", new Object[]{LEXICAL_HANDLER}));
        }
        this.fLexicalHandler = lexicalHandler;
    }

    protected LexicalHandler getLexicalHandler() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fLexicalHandler;
    }

    protected final void startNamespaceMapping() throws SAXException {
        int n = this.fNamespaceContext.getDeclaredPrefixCount();
        if (n > 0) {
            String string2 = null;
            String string3 = null;
            int n2 = 0;
            while (n2 < n) {
                string3 = this.fNamespaceContext.getURI(string2 = this.fNamespaceContext.getDeclaredPrefixAt(n2));
                this.fContentHandler.startPrefixMapping(string2, string3 == null ? "" : string3);
                ++n2;
            }
        }
    }

    protected final void endNamespaceMapping() throws SAXException {
        int n = this.fNamespaceContext.getDeclaredPrefixCount();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                this.fContentHandler.endPrefixMapping(this.fNamespaceContext.getDeclaredPrefixAt(n2));
                ++n2;
            }
        }
    }

    public void reset() throws XNIException {
        super.reset();
        this.fInDTD = false;
        this.fVersion = "1.0";
        this.fStandalone = false;
        this.fNamespaces = this.fConfiguration.getFeature(NAMESPACES);
        this.fAugmentations = null;
        this.fDeclaredAttrs = null;
    }

    public ElementPSVI getElementPSVI() {
        return this.fAugmentations != null ? (ElementPSVI)this.fAugmentations.getItem("ELEMENT_PSVI") : null;
    }

    public AttributePSVI getAttributePSVI(int n) {
        return (AttributePSVI)this.fAttributesProxy.fAttributes.getAugmentations(n).getItem("ATTRIBUTE_PSVI");
    }

    public AttributePSVI getAttributePSVIByName(String string2, String string3) {
        return (AttributePSVI)this.fAttributesProxy.fAttributes.getAugmentations(string2, string3).getItem("ATTRIBUTE_PSVI");
    }

    protected static final class AttributesProxy
    implements AttributeList,
    Attributes2 {
        protected XMLAttributes fAttributes;

        protected AttributesProxy() {
        }

        public void setAttributes(XMLAttributes xMLAttributes) {
            this.fAttributes = xMLAttributes;
        }

        public int getLength() {
            return this.fAttributes.getLength();
        }

        public String getName(int n) {
            return this.fAttributes.getQName(n);
        }

        public String getQName(int n) {
            return this.fAttributes.getQName(n);
        }

        public String getURI(int n) {
            String string2 = this.fAttributes.getURI(n);
            return string2 != null ? string2 : "";
        }

        public String getLocalName(int n) {
            return this.fAttributes.getLocalName(n);
        }

        public String getType(int n) {
            return this.fAttributes.getType(n);
        }

        public String getType(String string2) {
            return this.fAttributes.getType(string2);
        }

        public String getType(String string2, String string3) {
            return string2.length() == 0 ? this.fAttributes.getType(null, string3) : this.fAttributes.getType(string2, string3);
        }

        public String getValue(int n) {
            return this.fAttributes.getValue(n);
        }

        public String getValue(String string2) {
            return this.fAttributes.getValue(string2);
        }

        public String getValue(String string2, String string3) {
            return string2.length() == 0 ? this.fAttributes.getValue(null, string3) : this.fAttributes.getValue(string2, string3);
        }

        public int getIndex(String string2) {
            return this.fAttributes.getIndex(string2);
        }

        public int getIndex(String string2, String string3) {
            return string2.length() == 0 ? this.fAttributes.getIndex(null, string3) : this.fAttributes.getIndex(string2, string3);
        }

        public boolean isDeclared(int n) {
            if (n < 0 || n >= this.fAttributes.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            return Boolean.TRUE.equals(this.fAttributes.getAugmentations(n).getItem("ATTRIBUTE_DECLARED"));
        }

        public boolean isDeclared(String string2) {
            int n = this.getIndex(string2);
            if (n == -1) {
                throw new IllegalArgumentException(string2);
            }
            return Boolean.TRUE.equals(this.fAttributes.getAugmentations(n).getItem("ATTRIBUTE_DECLARED"));
        }

        public boolean isDeclared(String string2, String string3) {
            int n = this.getIndex(string2, string3);
            if (n == -1) {
                throw new IllegalArgumentException(string3);
            }
            return Boolean.TRUE.equals(this.fAttributes.getAugmentations(n).getItem("ATTRIBUTE_DECLARED"));
        }

        public boolean isSpecified(int n) {
            if (n < 0 || n >= this.fAttributes.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            return this.fAttributes.isSpecified(n);
        }

        public boolean isSpecified(String string2) {
            int n = this.getIndex(string2);
            if (n == -1) {
                throw new IllegalArgumentException(string2);
            }
            return this.fAttributes.isSpecified(n);
        }

        public boolean isSpecified(String string2, String string3) {
            int n = this.getIndex(string2, string3);
            if (n == -1) {
                throw new IllegalArgumentException(string3);
            }
            return this.fAttributes.isSpecified(n);
        }
    }

    protected static final class LocatorProxy
    implements Locator2 {
        protected XMLLocator fLocator;

        public LocatorProxy(XMLLocator xMLLocator) {
            this.fLocator = xMLLocator;
        }

        public String getPublicId() {
            return this.fLocator.getPublicId();
        }

        public String getSystemId() {
            return this.fLocator.getExpandedSystemId();
        }

        public int getLineNumber() {
            return this.fLocator.getLineNumber();
        }

        public int getColumnNumber() {
            return this.fLocator.getColumnNumber();
        }

        public String getXMLVersion() {
            return this.fLocator.getXMLVersion();
        }

        public String getEncoding() {
            return this.fLocator.getEncoding();
        }
    }
}

