/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystem.utility.MpmPlutoDevice;

public class MpmSimPlutoDevice
extends MpmPlutoDevice {
    static final List<Integer>[] clearList = new ArrayList[11];
    private final boolean[] switches = new boolean[7];
    private final Boolean[] latches = new Boolean[11];
    private final boolean[] conditions = new boolean[7];

    protected void initDevice() {
    }

    protected void initialize() {
        this.setOnline(true);
    }

    protected void close() {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) {
        return new int[]{0, 0};
    }

    protected void readChannelGroup() {
    }

    protected double readChannel(int hwChan, int type) {
        return 315.0 + (double)hwChan;
    }

    @Override
    public Boolean isPlcActive(int plc) {
        return true;
    }

    @Override
    public void setSwitchOn(int sw, boolean on) {
        this.switches[sw] = on;
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        return this.switches[sw];
    }

    @Override
    public Boolean isLatchActive(int cond) {
        Boolean latch = this.latches[cond];
        return latch != null && latch != false;
    }

    @Override
    public Boolean isLatchLatched(int cond) {
        Boolean latch = this.latches[cond];
        return latch != null && latch == false;
    }

    @Override
    public void clearLatch(int cond) {
        for (int cnd : clearList[cond]) {
            Boolean latch = this.latches[cnd];
            this.latches[cnd] = latch != null && latch == false ? null : latch;
        }
    }

    @Override
    public Boolean isConditionActive(int cond) {
        return this.conditions[cond];
    }

    @Command(type=Command.CommandType.ACTION)
    public void setLatchActive(@Argument(description="Latched condition number") int cond) {
        this.latches[cond] = true;
    }

    @Command(type=Command.CommandType.ACTION)
    public void setLatchLatched(@Argument(description="Latched condition number") int cond) {
        this.latches[cond] = false;
    }

    @Command(type=Command.CommandType.ACTION)
    public void setCondition(@Argument(description="Running condition number") int cond, @Argument(description="Condition on state") boolean set) {
        this.conditions[cond] = set;
    }

    static {
        for (int cond = 0; cond < 11; ++cond) {
            MpmSimPlutoDevice.clearList[cond] = new ArrayList<Integer>();
        }
        clearList[5].add(5);
        clearList[6].add(6);
        clearList[7].add(7);
        clearList[8].add(8);
        clearList[9].add(9);
        clearList[10].add(10);
        clearList[1].add(1);
        clearList[1].add(2);
        clearList[2].add(1);
        clearList[2].add(2);
        clearList[3].add(3);
        clearList[3].add(4);
        clearList[4].add(3);
        clearList[4].add(4);
        clearList[0].add(0);
    }
}

