/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.i2c.I2c;
import org.lsst.ccs.drivers.lambda.Cpfe1000;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class CpfeDevice
extends Device {
    public static final int CHAN_STATUS = 0;
    public static final int CHAN_TEMPERATURE = 1;
    public static final int CHAN_VOLTAGE = 2;
    public static final int CHAN_CURRENT = 3;
    public static final int NUM_CHANS = 4;
    private static final Map<String, I2c.ConnType> cTypeMap = new HashMap<String, I2c.ConnType>();
    private String connType;
    private String devcId;
    private int address = 160;
    private final Logger sLog = Logger.getLogger((String)((Object)((Object)this)).getClass().getPackage().getName());
    private final Cpfe1000 cpfe = new Cpfe1000();
    private I2c.ConnType cType;

    protected void initDevice() {
        if (this.connType == null) {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.name, (String)"connType", (String)"is missing");
        }
        this.cType = cTypeMap.get(this.connType.toUpperCase());
        if (this.cType == null) {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.name, (String)"connType", (String)"is invalid");
        }
        if (this.devcId == null) {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.name, (String)"devcId", (String)"is missing");
        }
        this.fullName = "CPFE1000 (" + this.devcId + ":" + this.address + ")";
    }

    protected void initialize() {
        try {
            this.cpfe.open(this.cType, this.devcId, this.address);
            this.setOnline(true);
            this.initSensors();
            this.log.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.cpfe.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 4) {
            MonitorLogUtils.reportError((Logger)this.sLog, (String)name, (String)"hwchan", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        try {
            switch (hwChan) {
                case 0: {
                    value = this.cpfe.readStatus();
                    break;
                }
                case 1: {
                    value = this.cpfe.readTemperature();
                    break;
                }
                case 2: {
                    value = this.cpfe.readVoltage();
                    break;
                }
                case 3: {
                    value = this.cpfe.readCurrent();
                }
            }
        }
        catch (DriverException e) {
            this.sLog.error((Object)("Error reading CPFE1000 data: " + (Object)((Object)e)));
            this.setOnline(false);
        }
        return value;
    }

    static {
        cTypeMap.put("SERIAL", I2c.ConnType.SERIALUSB);
        cTypeMap.put("FTDI", I2c.ConnType.FTDIUSB);
    }
}

