package org.lsst.ccs.subsystem.utility;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.subsystem.utility.data.MpmSysState;

/**
 *  Definitions of the vacuum system switch names.
 *
 *  @author The CCS team
 */
public class SwitchNames {

    public static final String
        BLOCK_COLD_HEAT = "BlockColdHeat",
        BLOCK_COLD_REFG = "BlockColdRefg",
        BLOCK_CRYO_HEAT = "BlockCryoHeat",
        BLOCK_CRYO_REFG = "BlockCryoRefg",
        BLOCK_COOLANT   = "BlockCoolant",
        BLOCK_REB_POWER = "BlockRebPower",
        BLOCK_UT_POWER  = "BlockUtPower";

    public static final Map<String, Integer> NAME_MAP = new HashMap<>();
    static {
        NAME_MAP.put(BLOCK_COLD_HEAT, MpmSysState.SW_BLOCK_COLD_HEAT);
        NAME_MAP.put(BLOCK_COLD_REFG, MpmSysState.SW_BLOCK_COLD_REFG);
        NAME_MAP.put(BLOCK_CRYO_HEAT, MpmSysState.SW_BLOCK_CRYO_HEAT);
        NAME_MAP.put(BLOCK_CRYO_REFG, MpmSysState.SW_BLOCK_CRYO_REFG);
        NAME_MAP.put(BLOCK_COOLANT, MpmSysState.SW_BLOCK_COOLANT);
        NAME_MAP.put(BLOCK_REB_POWER, MpmSysState.SW_BLOCK_REB_POWER);
        NAME_MAP.put(BLOCK_UT_POWER, MpmSysState.SW_BLOCK_UT_POWER);
    }

}
