/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.abb;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.modbus.Modbus;

public class Cms
extends Modbus {
    public static final int DEFAULT_BAUD_RATE = 19200;
    public static final int NUM_SENSORS = 64;
    private static final short ADDR_TRIGGER = 12304;
    private static final short ADDR_SHOW = 12305;
    private static final short CMD_TRIGGER = 16;
    private static final short CMD_RESET = 1;
    private static final short CMD_BLINK = 4096;
    private static final short ZERO = 0;
    private static final short ONE = 1;
    private static final int BASE_ADDR_INST = 0;
    private static final int BASE_ADDR_MIN = 1024;
    private static final int BASE_ADDR_MAX = 2048;
    private static final int BASE_ADDR_HOLD = 3072;
    private static final int OFF_ADDR_RMS = 0;
    private static final int OFF_ADDR_AC = 256;
    private static final int OFF_ADDR_DC = 512;

    public Cms() {
        super(Ascii.Option.NO_NET);
    }

    @Override
    public void open(Modbus.ConnType type, String ident, int parm1, int parm2) throws DriverException {
        super.open(type, ident, parm1 == 0 ? 19200 : parm1, parm2);
        super.setAddressMode(true);
    }

    @Override
    public void open(Modbus.ConnType type, String ident, int baud) throws DriverException {
        this.open(type, ident, baud, Cms.makeDataCharacteristics((Ascii.DataBits)Ascii.DataBits.EIGHT, (Ascii.StopBits)Ascii.StopBits.TWO, (Ascii.Parity)Ascii.Parity.EVEN, (Ascii.FlowCtrl)Ascii.FlowCtrl.NONE));
    }

    @Override
    public void setAddressMode(boolean mode) {
    }

    public double readRMS(int bAddr, int sensor) throws DriverException {
        this.checkSensor(sensor);
        return this.readSensor(bAddr, 0 + sensor - 1);
    }

    public double readAC(int bAddr, int sensor) throws DriverException {
        this.checkSensor(sensor);
        return this.readSensor(bAddr, 256 + sensor - 1);
    }

    public double readDC(int bAddr, int sensor) throws DriverException {
        this.checkSensor(sensor);
        return this.readSensor(bAddr, 512 + sensor - 1);
    }

    public double readMaxRMS(int bAddr, int sensor) throws DriverException {
        this.checkSensor(sensor);
        return this.readSensor(bAddr, 2048 + sensor - 1);
    }

    public double readMaxAC(int bAddr, int sensor) throws DriverException {
        this.checkSensor(sensor);
        return this.readSensor(bAddr, 2304 + sensor - 1);
    }

    public double readMaxDC(int bAddr, int sensor) throws DriverException {
        this.checkSensor(sensor);
        return this.readSensor(bAddr, 2560 + sensor - 1);
    }

    public double readMinRMS(int bAddr, int sensor) throws DriverException {
        this.checkSensor(sensor);
        return this.readSensor(bAddr, 1024 + sensor - 1);
    }

    public double readMinAC(int bAddr, int sensor) throws DriverException {
        this.checkSensor(sensor);
        return this.readSensor(bAddr, 1280 + sensor - 1);
    }

    public double readMinDC(int bAddr, int sensor) throws DriverException {
        this.checkSensor(sensor);
        return this.readSensor(bAddr, 1536 + sensor - 1);
    }

    public double readHeldRMS(int bAddr, int sensor) throws DriverException {
        this.checkSensor(sensor);
        return this.readSensor(bAddr, 3072 + sensor - 1);
    }

    public double readHeldAC(int bAddr, int sensor) throws DriverException {
        this.checkSensor(sensor);
        return this.readSensor(bAddr, 3328 + sensor - 1);
    }

    public double readHeldDC(int bAddr, int sensor) throws DriverException {
        this.checkSensor(sensor);
        return this.readSensor(bAddr, 3584 + sensor - 1);
    }

    public void resetExtrema(int bAddr) throws DriverException {
        this.writeRegister((short)bAddr, (short)12304, (short)1);
    }

    public void triggerHold(int bAddr) throws DriverException {
        this.writeRegister((short)bAddr, (short)12304, (short)16);
    }

    public void showSensor(int bAddr, int sensor, boolean show) throws DriverException {
        this.checkSensor(sensor);
        this.writeRegister((short)bAddr, (short)12305, (short)((show ? 4096 : 0) | sensor));
    }

    private double readSensor(int bAddr, int addr) throws DriverException {
        return (double)this.readRegisters((short)bAddr, (short)addr, (short)1)[0] * 0.01;
    }

    private void checkSensor(int sensor) throws DriverException {
        if (sensor <= 0 || sensor > 64) {
            throw new DriverException("Invalid sensor number");
        }
    }
}

