/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending.timeselection;

import java.awt.Component;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.PresetList;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindowDialog;

public class PresetsDialog {
    private final JScrollPane root;
    private final JButton editButton;
    private final JButton deleteButton;
    private final JButton newButton;
    private final JButton okButton;
    private final JTable table;
    private final PresetList timeWindowList;
    private TimeWindow selectedTimeWindow;

    private PresetsDialog(PresetList data) {
        this.timeWindowList = data;
        this.editButton = new JButton("Edit...");
        this.editButton.addActionListener(e -> {
            TimeWindow ts = this.getSelectedPreset();
            if ((ts = TimeWindowDialog.editTimeWindow(this.editButton, ts)) != null) {
                this.timeWindowList.insert(ts);
                this.setSelectedPreset(ts);
            }
        });
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(e -> {
            TimeWindow ts = this.getSelectedPreset();
            if (ts != null) {
                this.timeWindowList.delete(ts);
            }
        });
        this.newButton = new JButton("New...");
        this.newButton.addActionListener(e -> {
            TimeWindow ts = TimeWindowDialog.editTimeWindow(this.newButton, null);
            if (ts != null) {
                this.timeWindowList.insert(ts);
                this.setSelectedPreset(ts);
            }
        });
        this.okButton = new JButton(" Close ");
        this.okButton.addActionListener(e -> {
            this.selectedTimeWindow = this.getSelectedPreset();
            Window w = SwingUtilities.getWindowAncestor(this.okButton);
            if (w != null) {
                w.setVisible(false);
            }
        });
        this.table = new JTable(this.timeWindowList);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(e -> {
            TimeWindow ts = this.getSelectedPreset();
            this.editButton.setEnabled(ts != null);
            this.deleteButton.setEnabled(ts != null);
        });
        if (this.timeWindowList.getRowCount() > 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.table.setMinimumSize(this.table.getPreferredSize());
        this.root = new JScrollPane(this.table);
    }

    public static TimeWindow managePresets(Component parent, PresetList data) {
        PresetsDialog dialog = new PresetsDialog(data);
        JOptionPane.showOptionDialog(parent, dialog.root, "Trending Time Window Presets", -1, -1, null, new JButton[]{dialog.editButton, dialog.deleteButton, dialog.newButton, dialog.okButton}, dialog.okButton);
        return dialog.selectedTimeWindow;
    }

    private TimeWindow getSelectedPreset() {
        int index = this.table.getSelectedRow();
        return index == -1 ? null : this.timeWindowList.get(index);
    }

    private void setSelectedPreset(TimeWindow ts) {
        int index = this.timeWindowList.indexOf(ts);
        if (index == -1) {
            this.table.getSelectionModel().clearSelection();
        } else {
            this.table.getSelectionModel().setSelectionInterval(index, index);
        }
    }
}

