/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorLogUtils;

public class Line
implements HasLifecycle {
    protected String devcName;
    protected int chan;
    protected String compDevcName;
    protected int compChan;
    private Device device;
    private Device compDevice;
    @LookupName
    protected String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected Monitor mon;

    @Override
    public void init() {
        this.configure(this.mon);
    }

    void configure(Monitor mon) {
        try {
            if (this.devcName != null) {
                this.device = mon.getDevice(this.devcName);
                if (this.device == null) {
                    MonitorLogUtils.reportError(mon.subsys.getLogger(), this.name, "device", this.devcName);
                } else {
                    this.device.checkLine(this.name, this.chan);
                }
            }
            if (this.compDevcName != null) {
                this.compDevice = mon.getDevice(this.compDevcName);
                if (this.compDevice == null) {
                    MonitorLogUtils.reportError(mon.subsys.getLogger(), this.name, "device", this.compDevcName);
                } else {
                    this.compDevice.checkLine(this.name, this.compChan);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWarm(boolean on) {
        if (this.device != null) {
            this.device.setLineWarm(this.chan, on);
        }
        if (this.compDevice != null) {
            this.compDevice.setLineWarm(this.compChan, !on);
        }
    }

    public void set(boolean on) {
        if (this.device != null && this.device.isOnline()) {
            this.device.setLine(this.chan, on);
        }
        if (this.compDevice != null && this.compDevice.isOnline()) {
            this.compDevice.setLine(this.compChan, !on);
        }
    }

    public Boolean isSet() {
        Boolean state = null;
        if (this.device != null && this.device.isOnline()) {
            state = this.device.isLineSet(this.chan);
        } else if (this.compDevice != null && this.compDevice.isOnline()) {
            state = this.compDevice.isLineSet(this.compChan);
            state = state != null ? Boolean.valueOf(state == false) : null;
        }
        return state;
    }

    public String getName() {
        return this.name;
    }

    public Monitor getMonitor() {
        return this.mon;
    }

    public Device getDevice() {
        return this.device;
    }

    public Device getCompDevice() {
        return this.compDevice;
    }

    public int getChannel() {
        return this.chan;
    }

    public int getCompChannel() {
        return this.compChan;
    }
}

