/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import org.lsst.ccs.drivers.auxelex.Srp;
import org.lsst.ccs.drivers.commons.DriverException;

public class LTC2945 {
    private final int ADC_INCREMENT = 1024;
    private final int ADC_CONTROL = 0;
    private final int ADC_ALERT = 1;
    private final int ADC_STATUS = 2;
    private final int ADC_FAULT = 3;
    private final int ADC_FAULT_COR = 4;
    private final int ADC_POWER_BASE = 5;
    private final int ADC_SENSE_BASE = 10;
    private final int ADC_V_IN_BASE = 15;
    private final int ADC_AD_IN_BASE = 20;
    private final int ADC_CURR_MEAS = 0;
    private final int ADC_MAX_MEAS = 1;
    private final int ADC_MIN_MEAS = 2;
    private final int ADC_MAX_THRESH = 3;
    private final int ADC_MIN_THRESH = 4;
    private static final double VOLT_SCALE = 0.025;
    private static final double CURR_SCALE = 2.5E-5;
    private final Srp srp;
    private final int adcBase;

    public LTC2945(Srp srp, int adcBase) {
        this.srp = srp;
        this.adcBase = adcBase;
    }

    public double readVoltage(int chan) throws DriverException {
        return (double)this.srp.readReg(this.adcBase + 1024 * chan + 15 + 0) * 0.025;
    }

    public double readCurrent(int chan) throws DriverException {
        return (double)this.srp.readReg(this.adcBase + 1024 * chan + 10 + 0) * 2.5E-5;
    }

    public void simSetVoltage(int chan, double value) {
        this.srp.putSimRegMap(this.adcBase + 1024 * chan + 15 + 0, (int)(value / 0.025));
    }

    public void simSetCurrent(int chan, double value) {
        this.srp.putSimRegMap(this.adcBase + 1024 * chan + 10 + 0, (int)(value / 2.5E-5));
    }
}

