/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.jgroups;

import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import org.jgroups.tests.Probe;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;
import org.lsst.ccs.gconsole.services.persist.Savable;
import org.lsst.ccs.gconsole.util.swing.BoxedComboBox;
import org.lsst.ccs.gconsole.util.swing.BoxedTextField;

public final class ProbePage
extends JScrollPane
implements Savable {
    JTextField probeCommand;
    JTextField timeoutField;
    JTextField matchField;
    JButton probeSend;
    JButton probeHelp;
    JCheckBox verboseBox;
    JCheckBox weedOutDuplicatesBox;
    JCheckBox timeoutBox;
    JCheckBox busBox;
    JCheckBox matchBox;
    JComboBox<String> busCombo;

    public ProbePage() {
        Box root = Box.createVerticalBox();
        this.setViewportView(root);
        Box probe = Box.createVerticalBox();
        root.add(probe);
        probe.setBorder(BorderFactory.createTitledBorder("Probe"));
        Box line = Box.createHorizontalBox();
        probe.add(line);
        line.add(Box.createRigidArea(Const.HDIM));
        this.probeCommand = new BoxedTextField();
        line.add(this.probeCommand);
        line.add(Box.createRigidArea(Const.HDIM));
        this.probeSend = new JButton("Send");
        line.add(this.probeSend);
        this.probeSend.addActionListener(e -> this.sendProbe());
        line.add(Box.createRigidArea(Const.HDIM));
        this.probeHelp = new JButton("Help");
        line.add(this.probeHelp);
        this.probeHelp.addActionListener(e -> Console.getConsole().showInBrowser("http://www.jgroups.org/manual4/index.html#Probe"));
        line.add(Box.createRigidArea(Const.HDIM));
        line.add(Box.createHorizontalGlue());
        probe.add(Box.createRigidArea(Const.VDIM));
        line = Box.createHorizontalBox();
        probe.add(line);
        line.add(Box.createRigidArea(Const.HDIM));
        this.verboseBox = new JCheckBox("Verbose");
        line.add(this.verboseBox);
        line.add(Box.createRigidArea(Const.HDIM2));
        this.weedOutDuplicatesBox = new JCheckBox("Weed out duplicates");
        line.add(this.weedOutDuplicatesBox);
        line.add(Box.createRigidArea(Const.HDIM));
        line.add(Box.createHorizontalGlue());
        probe.add(Box.createRigidArea(Const.VDIM));
        line = Box.createHorizontalBox();
        probe.add(line);
        line.add(Box.createRigidArea(Const.HDIM));
        this.timeoutBox = new JCheckBox("Timeout : ");
        line.add(this.timeoutBox);
        this.timeoutBox.addActionListener(e -> this.timeoutField.setEnabled(this.timeoutBox.isSelected()));
        this.timeoutField = new BoxedTextField(0);
        this.timeoutField.setColumns(4);
        this.timeoutField.setMaximumSize(this.timeoutField.getPreferredSize());
        line.add(this.timeoutField);
        line.add(new JLabel(" seconds."));
        line.add(Box.createRigidArea(Const.HDIM));
        line.add(Box.createHorizontalGlue());
        probe.add(Box.createRigidArea(Const.VDIM));
        String tip = "Select CCS bus, or enter an arbitrary JGroups cluster name";
        line = Box.createHorizontalBox();
        probe.add(line);
        line.add(Box.createRigidArea(Const.HDIM));
        this.busBox = new JCheckBox("Bus : ");
        line.add(this.busBox);
        this.busBox.setToolTipText(tip);
        this.busBox.addActionListener(e -> this.busCombo.setEnabled(this.busBox.isSelected()));
        line.add(Box.createRigidArea(Const.HDIM));
        this.busCombo = new BoxedComboBox<String>();
        line.add(this.busCombo);
        this.busCombo.setToolTipText(tip);
        this.busCombo.setEditable(true);
        this.busCombo.addItem("");
        for (Bus bus : Bus.values()) {
            this.busCombo.addItem(bus.toString());
        }
        line.add(Box.createRigidArea(Const.HDIM));
        line.add(Box.createHorizontalGlue());
        probe.add(Box.createRigidArea(Const.VDIM));
        tip = "Only responces that contain the specified pattern are printed";
        line = Box.createHorizontalBox();
        probe.add(line);
        line.add(Box.createRigidArea(Const.HDIM));
        this.matchBox = new JCheckBox("Match : ");
        line.add(this.matchBox);
        this.matchBox.setToolTipText(tip);
        this.matchBox.addActionListener(e -> this.matchField.setEnabled(this.matchBox.isSelected()));
        this.matchField = new BoxedTextField();
        line.add(this.matchField);
        this.matchField.setToolTipText(tip);
        line.add(Box.createRigidArea(Const.HDIM));
        line.add(Box.createHorizontalGlue());
        probe.add(Box.createRigidArea(Const.VDIM));
        root.add(Box.createVerticalGlue());
    }

    private void sendProbe() {
        String s;
        final ArrayList<String> args = new ArrayList<String>();
        String command = this.probeCommand.getText().trim();
        if (this.verboseBox.isSelected()) {
            args.add("-v ");
        }
        if (this.weedOutDuplicatesBox.isSelected()) {
            args.add("-weed_out_duplicates ");
        }
        if (this.timeoutBox.isSelected()) {
            try {
                s = this.timeoutField.getText().trim();
                int t = Integer.parseInt(s);
                if (t <= 0) {
                    throw new NumberFormatException();
                }
                args.add("-timeout");
                args.add(s);
            }
            catch (NumberFormatException x) {
                Console.getConsole().error("Timeout value should be a positive integer", x);
                return;
            }
        }
        if (this.busBox.isSelected()) {
            s = this.busCombo.getSelectedItem().toString().trim();
            if (s.isEmpty()) {
                Console.getConsole().error("Empty bus name");
                return;
            }
            args.add("-cluster");
            args.add(s);
        }
        if (this.matchBox.isSelected()) {
            s = this.matchField.getText().trim();
            if (s.isEmpty()) {
                Console.getConsole().error("Empty match pattern");
                return;
            }
            args.add("-match");
            args.add(s);
        }
        args.add(command);
        new SwingWorker(){

            protected Object doInBackground() throws Exception {
                try {
                    System.out.println("\nProbe " + String.join((CharSequence)" ", args));
                    Probe.main((String[])args.toArray(new String[0]));
                }
                catch (Exception x) {
                    Console.getConsole().error("Probe failure", x);
                }
                return null;
            }
        }.execute();
    }

    @Override
    public Descriptor save() {
        Object m;
        Descriptor d = new Descriptor();
        d.setCommand(this.probeCommand.getText().trim());
        d.setVerbose(this.verboseBox.isSelected());
        d.setWeedOutDuplicates(this.weedOutDuplicatesBox.isSelected());
        String time = this.timeoutField.getText();
        try {
            int seconds = Integer.parseInt(time);
            if (seconds < 1) {
                throw new NumberFormatException();
            }
            if (!this.timeoutBox.isSelected()) {
                seconds = -seconds;
            }
            d.setTimeout(seconds);
        }
        catch (NumberFormatException x) {
            d.setTimeout(0);
        }
        Object bus = this.busCombo.getSelectedItem().toString().trim();
        if (!((String)bus).isEmpty()) {
            if (!this.busBox.isSelected()) {
                bus = "^" + (String)bus;
            }
            d.setBus((String)bus);
        }
        if (!((String)(m = this.matchField.getText().trim())).isEmpty()) {
            if (!this.matchBox.isSelected()) {
                m = "^" + (String)m;
            }
            d.setMatch((String)m);
        }
        return d;
    }

    @Override
    public void restore(Serializable descriptor) {
        Descriptor d = descriptor instanceof Descriptor ? (Descriptor)descriptor : new Descriptor();
        this.probeCommand.setText(d.getCommand() == null ? "" : d.getCommand());
        this.verboseBox.setSelected(d.isVerbose());
        this.weedOutDuplicatesBox.setSelected(d.isWeedOutDuplicates());
        int t = d.getTimeout();
        if (t <= 0) {
            this.timeoutBox.setSelected(false);
            this.timeoutField.setText(Integer.toString(-t));
            this.timeoutField.setEnabled(false);
        } else {
            this.timeoutBox.setSelected(true);
            this.timeoutField.setText(Integer.toString(t));
            this.timeoutField.setEnabled(true);
        }
        String bus = d.getBus();
        if (bus == null) {
            this.busBox.setSelected(false);
            this.busCombo.setSelectedItem("");
            this.busCombo.setEnabled(false);
        } else if (bus.startsWith("^")) {
            this.busBox.setSelected(false);
            this.busCombo.setSelectedItem(bus.substring(1));
            this.busCombo.setEnabled(false);
        } else {
            this.busBox.setSelected(true);
            this.busCombo.setSelectedItem(bus);
            this.busCombo.setEnabled(true);
        }
        String m = d.getMatch();
        if (m == null) {
            this.matchBox.setSelected(false);
            this.matchField.setText("");
            this.matchField.setEnabled(false);
        } else if (m.startsWith("^")) {
            this.matchBox.setSelected(false);
            this.matchField.setText(m.substring(1));
            this.matchField.setEnabled(false);
        } else {
            this.matchBox.setSelected(true);
            this.matchField.setText(m);
            this.matchField.setEnabled(true);
        }
    }

    public static class Descriptor
    implements Serializable,
    Cloneable {
        private DataPanelDescriptor page;
        private String command;
        private boolean verbose;
        private boolean weedOutDuplicates;
        private String bus;
        private int timeout = -10;
        private String match;

        public String getCommand() {
            return this.command;
        }

        public void setCommand(String command) {
            this.command = command;
        }

        public String getMatch() {
            return this.match;
        }

        public void setMatch(String match) {
            this.match = match;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public String getBus() {
            return this.bus;
        }

        public void setBus(String bus) {
            this.bus = bus;
        }

        public boolean isWeedOutDuplicates() {
            return this.weedOutDuplicates;
        }

        public void setWeedOutDuplicates(boolean weedOutDuplicates) {
            this.weedOutDuplicates = weedOutDuplicates;
        }

        public boolean isVerbose() {
            return this.verbose;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public DataPanelDescriptor getPage() {
            return this.page;
        }

        public void setPage(DataPanelDescriptor page) {
            this.page = page;
        }
    }
}

