/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.utility.constants.FanState;
import org.lsst.ccs.subsystem.utility.constants.HeaterState;
import org.lsst.ccs.subsystem.utility.constants.PurgeTestFans;
import org.lsst.ccs.subsystem.utility.constants.PurgeTestHeaters;
import org.lsst.ccs.subsystem.utility.constants.PurgeTestSwitches;
import org.lsst.ccs.subsystem.utility.constants.PurgeTestValves;
import org.lsst.ccs.subsystem.utility.constants.SwitchState;
import org.lsst.ccs.subsystem.utility.constants.ValveState;
import org.lsst.ccs.subsystem.utility.constants.VpcControlState;
import org.lsst.ccs.subsystem.utility.data.PurgeTestState;

public class PurgeTestControlPanel
extends JPanel
implements UiUtilities.ActionHandler,
CommandSender.ReplyHandler {
    private static final Map<Integer, String> switchNames = new LinkedHashMap<Integer, String>();
    private static final String[] heaterNames;
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private SystemStatusPanel statusPanel;
    private JPanel switchPanel;
    private JPanel mpcPanel;
    private JPanel vpcPanel;
    private JPanel utPanel;
    private JPanel simPanel;
    private final JLabel[] switchLabel = new JLabel[5];
    private final JLabel[] switchState = new JLabel[5];
    private final ButtonGroup[] switchBG = new ButtonGroup[5];
    private final JRadioButton[] switchOffRB = new JRadioButton[5];
    private final JRadioButton[] switchOnRB = new JRadioButton[5];
    private final JLabel[] fanState = new JLabel[3];
    private final ButtonGroup[] fanBG = new ButtonGroup[3];
    private final JRadioButton[] fanOffRB = new JRadioButton[3];
    private final JRadioButton[] fanSpeedRB = new JRadioButton[3];
    private final TextFieldX[] fanSpeedTF = new TextFieldX[3];
    private final JRadioButton[] fanTempRB = new JRadioButton[3];
    private final TextFieldX[] fanTempTF = new TextFieldX[3];
    private final JLabel[] heaterState = new JLabel[3];
    private final ButtonGroup[] heaterBG = new ButtonGroup[3];
    private final JRadioButton[] heaterOffRB = new JRadioButton[3];
    private final JRadioButton[] heaterOnRB = new JRadioButton[3];
    private final TextFieldX[] heaterValueTF = new TextFieldX[3];
    private final JLabel[] valveState = new JLabel[2];
    private final ButtonGroup[] valveBG = new ButtonGroup[2];
    private final JRadioButton[] valveShutRB = new JRadioButton[2];
    private final JRadioButton[] valveOpenRB = new JRadioButton[2];
    private final TextFieldX[] valvePosnTF = new TextFieldX[2];
    private JLabel vpcState;
    private ButtonGroup vpcBG;
    private JRadioButton vpcManualRB;
    private JRadioButton vpcTempRB;
    private final Map<Integer, Integer> switchLines = new HashMap<Integer, Integer>();
    private static final long serialVersionUID = 1L;

    public PurgeTestControlPanel(String subsys) {
        this.sender = new CommandSender(subsys, (CommandSender.ReplyHandler)this);
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, "getFullState", new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((PurgeTestState)reply);
    }

    public void updatePanel(PurgeTestState rs) {
        SwingUtilities.invokeLater(new UpdatePurgeState(rs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        int line = 0;
        for (int swId : switchNames.keySet()) {
            this.switchLines.put(swId, line);
            this.switchLabel[line] = UiUtilities.newLabel((String)(switchNames.get(swId) + ":"), (int)0);
            this.switchState[line] = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(SwitchState.class));
            this.switchOnRB[line] = this.uiUtils.newRadioButton("On", "ST" + swId);
            this.switchOffRB[line] = this.uiUtils.newRadioButton("Off", "SF" + swId);
            ButtonGroup bg = this.switchBG[line] = new ButtonGroup();
            bg.add(this.switchOnRB[line]);
            bg.add(this.switchOffRB[line]);
            ++line;
        }
        this.vpcState = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(VpcControlState.class));
        this.vpcManualRB = this.uiUtils.newRadioButton("Manual", "MF0");
        this.vpcTempRB = this.uiUtils.newRadioButton("Temp", "MT0");
        this.vpcBG = new ButtonGroup();
        this.vpcBG.add(this.vpcManualRB);
        this.vpcBG.add(this.vpcTempRB);
        for (int fanId = 0; fanId < 3; ++fanId) {
            this.fanState[fanId] = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(FanState.class));
            this.fanOffRB[fanId] = this.uiUtils.newRadioButton("Off", "FF" + fanId);
            this.fanSpeedRB[fanId] = this.uiUtils.newRadioButton("Speed", "FS" + fanId);
            this.fanTempRB[fanId] = this.uiUtils.newRadioButton("Temp", "FT" + fanId);
            ButtonGroup bg = this.fanBG[fanId] = new ButtonGroup();
            bg.add(this.fanOffRB[fanId]);
            bg.add(this.fanSpeedRB[fanId]);
            bg.add(this.fanTempRB[fanId]);
            this.fanSpeedTF[fanId] = this.uiUtils.newTextFieldX("0000.00", "S" + fanId, 2, true);
            this.fanTempTF[fanId] = this.uiUtils.newTextFieldX("0000.00", "T" + fanId, 2, true);
        }
        for (int htrId = 0; htrId < 3; ++htrId) {
            this.heaterState[htrId] = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(HeaterState.class));
            this.heaterOffRB[htrId] = this.uiUtils.newRadioButton("Off", "HF" + htrId);
            this.heaterOnRB[htrId] = this.uiUtils.newRadioButton("On", "HT" + htrId);
            ButtonGroup bg = this.heaterBG[htrId] = new ButtonGroup();
            bg.add(this.heaterOffRB[htrId]);
            bg.add(this.heaterOnRB[htrId]);
            this.heaterValueTF[htrId] = this.uiUtils.newTextFieldX("0000.00", "H" + htrId, 2, true);
        }
        for (int vlvId = 0; vlvId < 2; ++vlvId) {
            this.valveState[vlvId] = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(ValveState.class));
            this.valveShutRB[vlvId] = this.uiUtils.newRadioButton("Shut", "VF" + vlvId);
            this.valveOpenRB[vlvId] = this.uiUtils.newRadioButton("Open", "VT" + vlvId);
            ButtonGroup bg = this.valveBG[vlvId] = new ButtonGroup();
            bg.add(this.valveShutRB[vlvId]);
            bg.add(this.valveOpenRB[vlvId]);
            this.valvePosnTF[vlvId] = this.uiUtils.newTextFieldX("0000.00", "V" + vlvId, 2, true);
        }
        this.statusPanel = new SystemStatusPanel(this.sender);
        this.switchPanel = UiUtilities.newBorderedPanel((String)"Power Control");
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = 17;
        gbs.insets = new Insets(0, 0, 4, 4);
        int numColm = 2;
        int colm = 0;
        gbs.gridy = -1;
        gbs.insets.top = 0;
        for (line = 0; line < this.switchLabel.length; ++line) {
            if (this.switchLabel[line] == null) continue;
            if (colm == 0) {
                gbs.gridx = 0;
                ++gbs.gridy;
            }
            gbs.insets.top = gbs.gridy == 0 ? 4 : 0;
            gbs.insets.left = colm == 0 ? 4 : 40;
            this.switchPanel.add((Component)this.switchLabel[line], gbs);
            ++gbs.gridx;
            gbs.insets.left = 4;
            this.switchPanel.add((Component)this.switchState[line], gbs);
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchOffRB[line], gbs);
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchOnRB[line], gbs);
            ++gbs.gridx;
            colm = (colm + 1) % numColm;
        }
        this.switchPanel.setMinimumSize(this.switchPanel.getPreferredSize());
        this.mpcPanel = UiUtilities.newBorderedPanel((String)"MPC Control");
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.anchor = 17;
        gbm.insets = new Insets(4, 4, 4, 4);
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.addFanLine(0, this.mpcPanel, gbm);
        this.mpcPanel.setMinimumSize(this.mpcPanel.getPreferredSize());
        this.vpcPanel = UiUtilities.newBorderedPanel((String)"VPC Control");
        GridBagConstraints gbv = new GridBagConstraints();
        gbv.anchor = 17;
        gbv.insets = new Insets(4, 4, 0, 4);
        gbv.gridx = 0;
        gbv.gridy = 0;
        this.addModeLine(this.vpcPanel, gbv);
        ++gbv.gridy;
        gbv.insets.top = 0;
        gbv.gridx = 0;
        this.addHeaterLine(0, this.vpcPanel, gbv);
        ++gbv.gridy;
        gbv.gridx = 0;
        this.addHeaterLine(1, this.vpcPanel, gbv);
        ++gbv.gridy;
        gbv.gridx = 0;
        this.addFanLine(1, this.vpcPanel, gbv);
        ++gbv.gridy;
        gbv.gridx = 0;
        gbv.insets.bottom = 4;
        this.addValveLine(1, this.vpcPanel, gbv);
        this.vpcPanel.setMinimumSize(this.vpcPanel.getPreferredSize());
        this.simPanel = UiUtilities.newBorderedPanel((String)"Simulator Control");
        GridBagConstraints gbe = new GridBagConstraints();
        gbe.anchor = 17;
        gbe.insets = new Insets(4, 4, 4, 4);
        gbe.gridx = 0;
        gbe.gridy = 0;
        this.addHeaterLine(2, this.simPanel, gbe);
        this.simPanel.setMinimumSize(this.simPanel.getPreferredSize());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.statusPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.switchPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.mpcPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.vpcPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.simPanel, gbc);
    }

    private void addFanLine(int fanId, JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)UiUtilities.newLabel((String)"Fan:", (int)0), gbc);
        ++gbc.gridx;
        gbc.insets.left = 4;
        panel.add((Component)this.fanState[fanId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.fanOffRB[fanId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.fanSpeedRB[fanId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.fanSpeedTF[fanId], gbc);
        ++gbc.gridx;
        gbc.insets.left = 0;
        panel.add((Component)UiUtilities.newLabel((String)"D/C", (int)0), gbc);
        gbc.insets.left = 4;
        ++gbc.gridx;
        if (PurgeTestFans.hasTempState[fanId]) {
            panel.add((Component)this.fanTempRB[fanId], gbc);
            ++gbc.gridx;
            panel.add((Component)this.fanTempTF[fanId], gbc);
            ++gbc.gridx;
            gbc.insets.left = 0;
            panel.add((Component)UiUtilities.newLabel((String)"\u00b0C", (int)0), gbc);
            gbc.insets.left = 4;
            ++gbc.gridx;
        }
    }

    private void addModeLine(JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)UiUtilities.newLabel((String)"Mode:", (int)0), gbc);
        ++gbc.gridx;
        gbc.insets.left = 4;
        panel.add((Component)this.vpcState, gbc);
        ++gbc.gridx;
        panel.add((Component)this.vpcManualRB, gbc);
        ++gbc.gridx;
        panel.add((Component)this.vpcTempRB, gbc);
        ++gbc.gridx;
    }

    private void addValveLine(int valveId, JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)UiUtilities.newLabel((String)"Valve:", (int)0), gbc);
        ++gbc.gridx;
        gbc.insets.left = 4;
        panel.add((Component)this.valveState[valveId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.valveShutRB[valveId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.valveOpenRB[valveId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.valvePosnTF[valveId], gbc);
        ++gbc.gridx;
        panel.add((Component)UiUtilities.newLabel((String)"%", (int)0), gbc);
        ++gbc.gridx;
    }

    private void addHeaterLine(int htrId, JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)UiUtilities.newLabel((String)(heaterNames[htrId] + ":"), (int)0), gbc);
        ++gbc.gridx;
        gbc.insets.left = 4;
        panel.add((Component)this.heaterState[htrId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.heaterOffRB[htrId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.heaterOnRB[htrId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.heaterValueTF[htrId], gbc);
        ++gbc.gridx;
        gbc.insets.left = 0;
        panel.add((Component)UiUtilities.newLabel((String)(htrId == 2 ? "D/C" : "\u00b0C"), (int)0), gbc);
        gbc.insets.left = 4;
        ++gbc.gridx;
    }

    public void handleRadioButton(String name) {
        char type = name.charAt(0);
        char action = name.charAt(1);
        int id = Integer.valueOf(name.substring(2));
        switch (type) {
            case 'S': {
                this.sender.sendCommand(null, "setSwitchOn", new Object[]{PurgeTestSwitches.switchIdToName.get(id), action == 'T'});
                break;
            }
            case 'M': {
                VpcControlState mState = action == 'T' ? VpcControlState.TEMP : VpcControlState.MANUAL;
                this.sender.sendCommand(null, "setVpcState", new Object[]{mState});
                break;
            }
            case 'F': {
                FanState fState = action == 'T' ? FanState.TEMP : (action == 'S' ? FanState.SPEED : FanState.OFF);
                this.sender.sendCommand(null, "setFanState", new Object[]{PurgeTestFans.fanIdToName.get(id), fState});
                break;
            }
            case 'V': {
                ValveState vState = action == 'T' ? ValveState.POSN : ValveState.SHUT;
                this.sender.sendCommand(null, "setValveState", new Object[]{PurgeTestValves.valveIdToName.get(id), vState});
                break;
            }
            case 'H': {
                HeaterState hState = action == 'T' ? HeaterState.ON : HeaterState.OFF;
                this.sender.sendCommand(null, "setHeaterState", new Object[]{PurgeTestHeaters.heaterIdToName.get(id), hState});
            }
        }
    }

    public void handleTextFieldX(String name, Object value) {
        char type = name.charAt(0);
        int id = Integer.valueOf(name.substring(1));
        switch (type) {
            case 'S': {
                this.sender.sendCommand(null, "setFanSpeed", new Object[]{PurgeTestFans.fanIdToName.get(id), (Double)value});
                break;
            }
            case 'T': {
                this.sender.sendCommand(null, "setFanDeltaTemp", new Object[]{PurgeTestFans.fanIdToName.get(id), (Double)value});
                break;
            }
            case 'V': {
                this.sender.sendCommand(null, "setValvePosition", new Object[]{PurgeTestValves.valveIdToName.get(id), (Double)value / 100.0});
                break;
            }
            case 'H': {
                this.sender.sendCommand(null, "setHeaterValue", new Object[]{PurgeTestHeaters.heaterIdToName.get(id), (Double)value});
            }
        }
    }

    static {
        switchNames.put(1, "BFR 24V PDU");
        switchNames.put(0, "BFR 48V PDU");
        switchNames.put(3, "24V PDU Main");
        switchNames.put(2, "48V PDU Main");
        switchNames.put(4, "Electronics");
        heaterNames = new String[3];
        PurgeTestControlPanel.heaterNames[0] = "Heater1";
        PurgeTestControlPanel.heaterNames[1] = "Heater2";
        PurgeTestControlPanel.heaterNames[2] = "Heater";
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            PurgeTestControlPanel.this.statusPanel.disablePanel();
            Iterator iterator = switchNames.keySet().iterator();
            while (iterator.hasNext()) {
                int swId = (Integer)iterator.next();
                int line = (Integer)PurgeTestControlPanel.this.switchLines.get(swId);
                PurgeTestControlPanel.this.switchState[line].setEnabled(false);
                PurgeTestControlPanel.this.switchOffRB[line].setEnabled(false);
                PurgeTestControlPanel.this.switchOnRB[line].setEnabled(false);
            }
            for (int fanId = 0; fanId < 3; ++fanId) {
                PurgeTestControlPanel.this.fanState[fanId].setEnabled(false);
                PurgeTestControlPanel.this.fanOffRB[fanId].setEnabled(false);
                PurgeTestControlPanel.this.fanSpeedRB[fanId].setEnabled(false);
                PurgeTestControlPanel.this.fanTempRB[fanId].setEnabled(false);
                PurgeTestControlPanel.this.fanSpeedTF[fanId].setDisabled();
                PurgeTestControlPanel.this.fanTempTF[fanId].setDisabled();
            }
            for (int htrId = 0; htrId < 3; ++htrId) {
                PurgeTestControlPanel.this.heaterState[htrId].setEnabled(false);
                PurgeTestControlPanel.this.heaterOffRB[htrId].setEnabled(false);
                PurgeTestControlPanel.this.heaterOnRB[htrId].setEnabled(false);
                PurgeTestControlPanel.this.heaterValueTF[htrId].setDisabled();
            }
            for (int vlvId = 0; vlvId < 2; ++vlvId) {
                PurgeTestControlPanel.this.valveState[vlvId].setEnabled(false);
                PurgeTestControlPanel.this.valveShutRB[vlvId].setEnabled(false);
                PurgeTestControlPanel.this.valveOpenRB[vlvId].setEnabled(false);
                PurgeTestControlPanel.this.valvePosnTF[vlvId].setDisabled();
            }
            PurgeTestControlPanel.this.vpcState.setEnabled(false);
            PurgeTestControlPanel.this.vpcManualRB.setEnabled(false);
            PurgeTestControlPanel.this.vpcTempRB.setEnabled(false);
            PurgeTestControlPanel.this.repaint();
        }
    }

    class UpdatePurgeState
    implements Runnable {
        private final PurgeTestState ps;

        UpdatePurgeState(PurgeTestState ps) {
            this.ps = ps;
        }

        @Override
        public void run() {
            JRadioButton selButton;
            PurgeTestControlPanel.this.statusPanel.updatePanel(this.ps.getTickMillis());
            Iterator iterator = switchNames.keySet().iterator();
            while (iterator.hasNext()) {
                int swId = (Integer)iterator.next();
                int line = (Integer)PurgeTestControlPanel.this.switchLines.get(swId);
                SwitchState st = this.ps.getSwitchState(swId);
                st = st == null ? SwitchState.OFFLINE : st;
                JLabel label = PurgeTestControlPanel.this.switchState[line];
                label.setText(st.toString());
                label.setForeground(st == SwitchState.ON ? UiConstants.GREEN : (st == SwitchState.OFF ? Color.BLACK : UiConstants.BLUE));
                st = this.ps.getSwitchBaseState(swId);
                JRadioButton selButton2 = st == SwitchState.ON ? PurgeTestControlPanel.this.switchOnRB[line] : PurgeTestControlPanel.this.switchOffRB[line];
                selButton2.setSelected(true);
                PurgeTestControlPanel.this.switchState[line].setEnabled(true);
                PurgeTestControlPanel.this.switchOffRB[line].setEnabled(true);
                PurgeTestControlPanel.this.switchOnRB[line].setEnabled(true);
            }
            for (int fanId = 0; fanId < 3; ++fanId) {
                FanState st = this.ps.getFanState(fanId);
                st = st == null ? FanState.OFFLINE : st;
                JLabel label = PurgeTestControlPanel.this.fanState[fanId];
                label.setText(st.toString());
                label.setForeground(st == FanState.TEMP ? UiConstants.GREEN : (st == FanState.SPEED ? UiConstants.YELLOW : (st == FanState.OFF ? Color.BLACK : UiConstants.BLUE)));
                st = this.ps.getFanBaseState(fanId);
                selButton = st == FanState.TEMP ? PurgeTestControlPanel.this.fanTempRB[fanId] : (st == FanState.SPEED ? PurgeTestControlPanel.this.fanSpeedRB[fanId] : PurgeTestControlPanel.this.fanOffRB[fanId]);
                selButton.setSelected(true);
                PurgeTestControlPanel.this.fanSpeedTF[fanId].update((Object)this.ps.getFanSpeed(fanId), true);
                PurgeTestControlPanel.this.fanTempTF[fanId].update((Object)this.ps.getDeltaTemp(fanId), true);
                PurgeTestControlPanel.this.fanState[fanId].setEnabled(true);
                PurgeTestControlPanel.this.fanOffRB[fanId].setEnabled(true);
                PurgeTestControlPanel.this.fanSpeedRB[fanId].setEnabled(true);
                PurgeTestControlPanel.this.fanTempRB[fanId].setEnabled(true);
            }
            for (int htrId = 0; htrId < 3; ++htrId) {
                HeaterState st = this.ps.getHeaterState(htrId);
                st = st == null ? HeaterState.OFFLINE : st;
                JLabel label = PurgeTestControlPanel.this.heaterState[htrId];
                label.setText(st.toString());
                label.setForeground(st == HeaterState.TEMP ? UiConstants.GREEN : (st == HeaterState.ON ? UiConstants.YELLOW : (st == HeaterState.OFF ? Color.BLACK : UiConstants.BLUE)));
                st = this.ps.getHeaterBaseState(htrId);
                selButton = st == HeaterState.ON ? PurgeTestControlPanel.this.heaterOnRB[htrId] : PurgeTestControlPanel.this.heaterOffRB[htrId];
                selButton.setSelected(true);
                PurgeTestControlPanel.this.heaterValueTF[htrId].update((Object)this.ps.getHeaterValue(htrId), true);
                PurgeTestControlPanel.this.heaterState[htrId].setEnabled(true);
                PurgeTestControlPanel.this.heaterOffRB[htrId].setEnabled(true);
                PurgeTestControlPanel.this.heaterOnRB[htrId].setEnabled(true);
            }
            for (int vlvId = 0; vlvId < 2; ++vlvId) {
                ValveState st = this.ps.getValveState(vlvId);
                st = st == null ? ValveState.OFFLINE : st;
                JLabel label = PurgeTestControlPanel.this.valveState[vlvId];
                label.setText(st.toString());
                label.setForeground(st == ValveState.TEMP ? UiConstants.GREEN : (st == ValveState.POSN ? UiConstants.YELLOW : (st == ValveState.SHUT ? Color.BLACK : UiConstants.BLUE)));
                st = this.ps.getValveBaseState(vlvId);
                selButton = st == ValveState.POSN ? PurgeTestControlPanel.this.valveOpenRB[vlvId] : PurgeTestControlPanel.this.valveShutRB[vlvId];
                selButton.setSelected(true);
                PurgeTestControlPanel.this.valvePosnTF[vlvId].update((Object)(100.0 * this.ps.getValvePosition(vlvId)), true);
                PurgeTestControlPanel.this.valveState[vlvId].setEnabled(true);
                PurgeTestControlPanel.this.valveShutRB[vlvId].setEnabled(true);
                PurgeTestControlPanel.this.valveOpenRB[vlvId].setEnabled(true);
            }
            VpcControlState vst = this.ps.getVpcState();
            vst = vst == null ? VpcControlState.MANUAL : vst;
            JLabel label = PurgeTestControlPanel.this.vpcState;
            label.setText(vst.toString());
            label.setForeground(vst == VpcControlState.TEMP ? UiConstants.GREEN : Color.BLACK);
            JRadioButton selButton3 = vst == VpcControlState.TEMP ? PurgeTestControlPanel.this.vpcTempRB : PurgeTestControlPanel.this.vpcManualRB;
            selButton3.setSelected(true);
            PurgeTestControlPanel.this.vpcState.setEnabled(true);
            PurgeTestControlPanel.this.vpcManualRB.setEnabled(true);
            PurgeTestControlPanel.this.vpcTempRB.setEnabled(true);
            PurgeTestControlPanel.this.repaint();
        }
    }
}

