/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.constants;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class UtilTrunkHeaters {
    public static final String HEATER_VPC1 = "VpcHeater1";
    public static final String HEATER_VPC2 = "VpcHeater2";
    public static final int HEATER_VPC1_ID = 0;
    public static final int HEATER_VPC2_ID = 1;
    public static final int NUM_VPC_HEATERS = 2;
    public static final int NUM_HEATERS = 2;
    private static final Map<Integer, Integer> heaterSwitchMap = new LinkedHashMap<Integer, Integer>();
    private static final Map<String, Integer> heaterNameToId;
    private static final Map<Integer, String> heaterIdToName;

    public static List<String> getNames() {
        return new ArrayList<String>(heaterNameToId.keySet());
    }

    public static String getName(int id) {
        return heaterIdToName.get(id);
    }

    public static int getId(String name) throws UtilityException {
        Integer id = heaterNameToId.get(name);
        if (id == null) {
            throw new UtilityException("Invalid heater name: " + name);
        }
        return id;
    }

    public static int getSwitch(int id) {
        return heaterSwitchMap.get(id);
    }

    static {
        heaterSwitchMap.put(0, 0);
        heaterSwitchMap.put(1, 1);
        heaterNameToId = new LinkedHashMap<String, Integer>();
        heaterNameToId.put(HEATER_VPC1, 0);
        heaterNameToId.put(HEATER_VPC2, 1);
        heaterIdToName = new LinkedHashMap<Integer, String>();
        for (Map.Entry<String, Integer> entry : heaterNameToId.entrySet()) {
            heaterIdToName.put(entry.getValue(), entry.getKey());
        }
    }
}

