/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.model;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.localdb.configdb.model.ParameterPath;
import org.lsst.ccs.localdb.configdb.model.PathObject;

@Entity
@Immutable
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"agentName", "componentName", "parameterName", "type", "category", "finalValue"}, name="ccs_config_parm_u")})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="org.lsst.ccs.localdb.configdb.model.ConfigurationParameter")
public class ConfigurationParameter
implements Serializable,
PathObject {
    private static final long serialVersionUID = 5660908759518934491L;
    private long id;
    private String agentName;
    private ParameterPath parameterPath;
    private String type;
    protected String descriptionStr;
    private String category;
    private String finalValue;

    protected ConfigurationParameter() {
    }

    public ConfigurationParameter(String agentName, ParameterPath path, String typeName, String description, String category, String finalValue) {
        this.agentName = agentName;
        this.parameterPath = path;
        this.type = typeName;
        this.descriptionStr = description;
        this.category = category;
        this.finalValue = finalValue;
    }

    @Id
    @GeneratedValue(generator="ID_SEQUENCE_GENERATOR")
    public long getId() {
        return this.id;
    }

    protected void setId(long id) {
        this.id = id;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public ParameterPath getParameterPath() {
        return this.parameterPath;
    }

    void setParameterPath(ParameterPath parameterPath) {
        this.parameterPath = parameterPath;
    }

    public String getDescriptionStr() {
        return this.descriptionStr;
    }

    void setDescriptionStr(String descriptionStr) {
        this.descriptionStr = descriptionStr;
    }

    @Transient
    public boolean isFinal() {
        return this.finalValue != null;
    }

    public void setFinalValue(String finalValue) {
        this.finalValue = finalValue;
    }

    public String getFinalValue() {
        return this.finalValue;
    }

    public String getCategory() {
        return this.category;
    }

    void setCategory(String category) {
        this.category = category;
    }

    @Override
    @Transient
    public ParameterPath getPath() {
        return this.parameterPath;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "{" + this.getId() + ": path=" + this.parameterPath.toString() + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.agentName);
        hash = 71 * hash + Objects.hashCode(this.parameterPath);
        hash = 71 * hash + Objects.hashCode(this.type);
        hash = 71 * hash + Objects.hashCode(this.category);
        hash = 71 * hash + Objects.hashCode(this.finalValue);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationParameter other = (ConfigurationParameter)obj;
        if (!Objects.equals(this.agentName, other.agentName)) {
            return false;
        }
        if (!Objects.equals(this.parameterPath, other.parameterPath)) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.category, other.category)) {
            return false;
        }
        return Objects.equals(this.finalValue, other.finalValue);
    }
}

