/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.freehep.application.Application;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.studio.Studio;
import org.freehep.graphicsbase.util.export.ExportDialog;
import org.freehep.graphicsbase.util.export.ExportFileType;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.gconsole.plugins.monitor.LazyTreeView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorDisplay;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorExport;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorPage;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.persist.Creator;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.AgentPresenceManager;

@Plugin(name="LSST Monitoring Plugin", id="monitor", description="LSST CCS monitoring data display service.")
public class LsstMonitorPlugin
extends ConsolePlugin {
    public static String MENU_NAME = "Monitoring";
    private final Studio app = (Studio)Application.getApplication();
    private final ArrayList<MonitorPage> currentViews = new ArrayList(0);
    private final ArrayDeque<MonitorPage.Descriptor> recentViews = new ArrayDeque(0);

    @Override
    public void initialize() {
        AbstractAction newView = new AbstractAction("New..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LsstMonitorPlugin.this.openManagedPage();
            }
        };
        this.getServices().addMenu(newView, "400: CCS Tools :-1:15", MENU_NAME + ":1");
        AbstractAction loadPage = new AbstractAction("Load..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                PersistenceService service = LsstMonitorPlugin.this.getConsole().getSingleton(PersistenceService.class);
                try {
                    MonitorPage page = (MonitorPage)service.make(null, "Load monitoring page", LsstMonitorPlugin.this.getConsole().getWindow(), "MonitorPage");
                    if (page != null) {
                        LsstMonitorPlugin.this.openManagedPage(page);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        };
        this.getServices().addMenu(loadPage, "400: CCS Tools :-1:15", MENU_NAME + ":2");
        AbstractAction a = new AbstractAction("Core States"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MonitorPage page = LsstMonitorPlugin.makeCoreStatesPage();
                    if (page != null) {
                        LsstMonitorPlugin.this.openManagedPage(page);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        };
        this.getServices().addMenu(a, "400: CCS Tools :-1:15", MENU_NAME + ":3", "Whole Camera:1");
        a = new AbstractAction("Versions"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MonitorPage page = (MonitorPage)PersistenceService.getService().make("MonitorPage", "Built-In/Versions", new Object[0]);
                    if (page != null) {
                        LsstMonitorPlugin.this.openManagedPage(page);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        };
        this.getServices().addMenu(a, "400: CCS Tools :-1:15", MENU_NAME + ":3", "Whole Camera:2");
        AgentPresenceManager apMan = this.getConsole().getMessagingAccess().getAgentPresenceManager();
        apMan.addAgentPresenceListener(new AgentPresenceListener(){

            public void connected(AgentInfo ... agents) {
                for (final AgentInfo info : agents) {
                    AgentInfo.AgentType type = info.getType();
                    if (AgentInfo.AgentType.CONSOLE.equals((Object)type) || AgentInfo.AgentType.LISTENER.equals((Object)type)) continue;
                    SwingUtilities.invokeLater(() -> {
                        AbstractAction act = new AbstractAction(info.getName()){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                LsstMonitorPlugin.this.openDefaultAgentView(e.getActionCommand());
                            }
                        };
                        LsstMonitorPlugin.this.getServices().addMenu(act, "400: CCS Tools :-1:15", MENU_NAME + ":4", "Subsystems:1");
                        act = new AbstractAction("Default Monitor"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                LsstMonitorPlugin.this.openDefaultAgentView(info.getName());
                            }
                        };
                        LsstMonitorPlugin.this.getServices().addMenu(act, "CCS Subsystems", info.getName() + ":-10:15");
                    });
                }
            }

            public void disconnected(AgentInfo ... agents) {
                SwingUtilities.invokeLater(() -> {
                    for (AgentInfo agent : agents) {
                        LsstMonitorPlugin.this.getConsole().removeMenu(" CCS Tools ", MENU_NAME, "Subsystems", agent.getName());
                        LsstMonitorPlugin.this.getConsole().removeMenu("CCS Subsystems", agent.getName(), "Default Monitor");
                    }
                });
            }
        });
        PageManager pm = this.app.getPageManager();
        pm.addPageListener((PageListener)new Saver());
    }

    public void openPage(MonitorView view) {
        JComponent panel = view.getPanel();
        if (panel != null) {
            HashMap<Panel, Object> par = new HashMap<Panel, Object>();
            par.put(Panel.TITLE, view.getName());
            Consumer<JComponent> onClose = c -> view.uninstall();
            par.put(Panel.ON_CLOSE, onClose);
            Console.getConsole().getPanelManager().open((Component)panel, par);
            view.install();
        }
    }

    public void closePage(MonitorView view) {
        PanelManager pm = this.getConsole().getPanelManager();
        JComponent panel = view.getPanel();
        if (panel != null) {
            pm.close(panel);
        }
        view.uninstall();
    }

    public void openManagedPage(MonitorPage.Descriptor desc) {
        MonitorPage monPage = null;
        if (desc == null) {
            this.openManagedPage();
        } else {
            monPage = new MonitorPage(desc);
        }
        this.openManagedPage(monPage);
    }

    private void openManagedPage() {
        try {
            MonitorPage monPage = new MonitorPage();
            monPage.getDescriptor().setCategory("MonitorPage");
            monPage.getDescriptor().setName("Monitor");
            Persistable.Descriptor viewDesc = new Persistable.Descriptor();
            Creator.Descriptor creDesc = new Creator.Descriptor("MonitorView", "Built-In/Default", new String[0]);
            viewDesc.setCreator(creDesc);
            monPage.getDescriptor().setView(viewDesc);
            Persistable.Descriptor filterDesc = new Persistable.Descriptor();
            creDesc = new Creator.Descriptor("AgentChannelsFilter", "Built-In/Unfiltered", new String[0]);
            filterDesc.setCreator(creDesc);
            monPage.getDescriptor().setFilter(filterDesc);
            monPage = monPage.edit("Open Monitor Page", null);
            this.openManagedPage(monPage);
        }
        catch (CancellationException monPage) {
        }
        catch (RuntimeException x) {
            this.getConsole().error("Error opening monitor page", x);
        }
    }

    public void openManagedPage(MonitorPage page) {
        JComponent panel;
        if (page != null && (panel = page.getPanel()) != null) {
            HashMap<String, Serializable> data;
            DataPanelDescriptor panDesc;
            MonitorPage.Descriptor desc = page.getDescriptor();
            HashMap<Object, Object> par = new HashMap<Object, Object>();
            if (desc != null && (panDesc = desc.getPanel()) != null && panDesc.isOpen() && (data = panDesc.getData()) != null) {
                par.putAll(data);
            }
            par.put(Panel.TITLE, page.getName());
            Consumer<JComponent> onClose = c -> this.onClose((JComponent)c);
            par.put(Panel.ON_CLOSE, onClose);
            Consumer<JComponent> onSaveAs = c -> {
                for (MonitorPage p : this.currentViews) {
                    if (c != p.getPanel()) continue;
                    PersistenceService service = this.getConsole().getSingleton(PersistenceService.class);
                    service.saveAs(p.save(), "Save monitor page", null);
                    break;
                }
            };
            par.put(Panel.ON_SAVE_AS, onSaveAs);
            Consumer<JComponent> onEdit = c -> {
                for (MonitorPage p : this.currentViews) {
                    if (c != p.getPanel()) continue;
                    try {
                        MonitorPage editedPage = p.edit("Edit page", null);
                        if (editedPage == null || editedPage == p) break;
                        SwingUtilities.invokeLater(() -> {
                            try {
                                this.getConsole().getPanelManager().close((Component)c);
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                // empty catch block
                            }
                            this.openManagedPage(editedPage);
                        });
                    }
                    catch (RuntimeException runtimeException) {}
                    break;
                }
            };
            par.put(Panel.ON_EDIT, onEdit);
            Console.getConsole().getPanelManager().open((Component)panel, par);
            page.getView().install();
            this.currentViews.add(page);
        }
    }

    private void openDefaultAgentView(String agentName) {
        MonitorPage.Descriptor mpDesc = new MonitorPage.Descriptor();
        mpDesc.setCategory("MonitorPage");
        mpDesc.setName(agentName);
        Persistable.Descriptor viewDesc = new Persistable.Descriptor();
        Creator.Descriptor creDesc = new Creator.Descriptor("MonitorView", "Built-In/Default", new String[0]);
        viewDesc.setCreator(creDesc);
        mpDesc.setView(viewDesc);
        Persistable.Descriptor filterDesc = new Persistable.Descriptor();
        creDesc = new Creator.Descriptor("AgentChannelsFilter", "Built-In/Generic", agentName, "[" + agentName + "]", "_null_", "_null_", "false", "_null_");
        filterDesc.setCreator(creDesc);
        mpDesc.setFilter(filterDesc);
        this.openManagedPage(mpDesc);
    }

    private void onClose(JComponent panel) {
        String name;
        MonitorPage monPage = null;
        Iterator<MonitorPage> it = this.currentViews.iterator();
        while (it.hasNext()) {
            MonitorPage p = it.next();
            if (panel != p.getPanel()) continue;
            monPage = p;
            it.remove();
            break;
        }
        if (monPage == null) {
            return;
        }
        monPage.getView().uninstall();
        MonitorPage.Descriptor pd = monPage.save();
        if (pd != null && (name = pd.getName()) != null) {
            Iterator<MonitorPage.Descriptor> itt = this.recentViews.iterator();
            while (itt.hasNext()) {
                if (!itt.next().getName().equals(name)) continue;
                itt.remove();
                break;
            }
            if (this.recentViews.size() > 9) {
                this.recentViews.pollLast();
            }
            this.recentViews.addFirst(pd);
            this.resetRecentMenu();
        }
    }

    private void resetRecentMenu() {
        Console console = this.getConsole();
        console.removeMenu(" CCS Tools ", MENU_NAME, "Recent");
        int i = 0;
        for (final MonitorPage.Descriptor desc : this.recentViews) {
            AbstractAction act = new AbstractAction(desc.getName()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LsstMonitorPlugin.this.openManagedPage(desc);
                }
            };
            this.getServices().addMenu(act, "400: CCS Tools :-1:15", MENU_NAME + ":100:100", "Recent:" + i++);
        }
    }

    @Override
    public ComponentDescriptor save() {
        Descriptor desc = new Descriptor(this.getServices().getDescriptor());
        if (!this.currentViews.isEmpty()) {
            MonitorPage.Descriptor[] current = this.currentViews.stream().map(page -> page.save()).collect(Collectors.toList()).toArray(new MonitorPage.Descriptor[0]);
            desc.setCurrentViews(current);
        }
        if (!this.recentViews.isEmpty()) {
            MonitorPage.Descriptor[] recent = this.recentViews.toArray(new MonitorPage.Descriptor[0]);
            desc.setRecentViews(recent);
        }
        return desc;
    }

    @Override
    public boolean restore(ComponentDescriptor storageBean, boolean lastRound) {
        PanelManager pm = this.getConsole().getPanelManager();
        for (MonitorPage page : new ArrayList<MonitorPage>(this.currentViews)) {
            pm.close(page.getPanel());
        }
        this.currentViews.clear();
        this.recentViews.clear();
        if (storageBean instanceof Descriptor) {
            Descriptor desc = (Descriptor)storageBean;
            MonitorPage.Descriptor[] mvd = desc.getCurrentViews();
            if (mvd != null) {
                for (MonitorPage.Descriptor d : mvd) {
                    this.openManagedPage(d);
                }
            }
            if (desc.getRecentViews() != null) {
                this.recentViews.addAll(Arrays.asList(desc.getRecentViews()));
            }
        }
        this.resetRecentMenu();
        return true;
    }

    public static void saveData(OutputStream out, String mimeType, List<AgentChannel> channels, List<MonitorField> fields) {
        PrintStream ps = new PrintStream(out);
        StringBuilder sb = new StringBuilder();
        for (MonitorField field : fields) {
            sb.append(field.getTitle()).append(",");
        }
        ps.println(sb.substring(0, sb.length() - 1));
        for (AgentChannel channel : channels) {
            sb = new StringBuilder();
            for (MonitorField field : fields) {
                sb.append((String)channel.get(field.getKey())).append(",");
            }
            ps.println(sb.substring(0, sb.length() - 1));
        }
    }

    @Create(category="MonitorPage", name="Core States", path="Built-In/Core States", description="Core states of all subsystems")
    public static MonitorPage makeCoreStatesPage() {
        MonitorPage.Descriptor mpDesc = new MonitorPage.Descriptor();
        mpDesc.setCategory("MonitorPage");
        mpDesc.setName("Core States");
        LazyTreeView.Descriptor viewDesc = new LazyTreeView.Descriptor();
        Creator.Descriptor creDesc = new Creator.Descriptor("MonitorView", "Built-In/Optimized Tree", new String[0]);
        viewDesc.setCreator(creDesc);
        TreeMap<String, Serializable> nodes = new TreeMap<String, Serializable>();
        LazyTreeView.InterNodeDescriptor root = new LazyTreeView.InterNodeDescriptor();
        root.setExpanded(true);
        root.setDisplayMode(LazyTreeView.InterNodeDescriptor.DisplayMode.MESH);
        root.setSort(LazyTreeView.InterNodeDescriptor.Sort.ALPHABETIC);
        nodes.put("", root);
        viewDesc.setNodes(nodes);
        mpDesc.setView(viewDesc);
        Persistable.Descriptor filterDesc = new Persistable.Descriptor();
        creDesc = new Creator.Descriptor("AgentChannelsFilter", "Built-In/Core States", "Core States", "_null_");
        filterDesc.setCreator(creDesc);
        mpDesc.setFilter(filterDesc);
        return (MonitorPage)PersistenceService.getService().make(mpDesc);
    }

    @Create(category="MonitorPage", name="Versions", path="Built-In/Versions", description="Software versions for all subsystems")
    public static MonitorPage makeVersionsPage() {
        MonitorPage.Descriptor mpDesc = new MonitorPage.Descriptor();
        mpDesc.setCategory("MonitorPage");
        mpDesc.setName("Versions");
        LazyTreeView.Descriptor viewDesc = new LazyTreeView.Descriptor();
        Creator.Descriptor creDesc = new Creator.Descriptor("MonitorView", "Built-In/Optimized Tree", new String[0]);
        viewDesc.setCreator(creDesc);
        TreeMap<String, Serializable> nodes = new TreeMap<String, Serializable>();
        LazyTreeView.InterNodeDescriptor root = new LazyTreeView.InterNodeDescriptor();
        root.setExpanded(true);
        root.setDisplayMode(LazyTreeView.InterNodeDescriptor.DisplayMode.MESH);
        root.setSort(LazyTreeView.InterNodeDescriptor.Sort.ALPHABETIC);
        nodes.put("", root);
        viewDesc.setNodes(nodes);
        mpDesc.setView(viewDesc);
        Persistable.Descriptor filterDesc = new Persistable.Descriptor();
        creDesc = new Creator.Descriptor("AgentChannelsFilter", "Built-In/Versions", "Versions", "_null_");
        filterDesc.setCreator(creDesc);
        mpDesc.setFilter(filterDesc);
        return (MonitorPage)PersistenceService.getService().make(mpDesc);
    }

    private class Saver
    extends CommandProcessor
    implements PageListener {
        private boolean on;

        private Saver() {
        }

        public void pageChanged(PageEvent pe) {
            PageContext context = pe.getPageContext();
            if (context == null) {
                return;
            }
            JComponent panel = (JComponent)context.getPage();
            if (panel == null) {
                return;
            }
            switch (pe.getID()) {
                case 3999: {
                    MonitorDisplay md = this.findMonitorDisplay(panel, false);
                    if (md == null) {
                        if (!this.on) break;
                        LsstMonitorPlugin.this.app.getCommandTargetManager().remove((CommandGroup)this);
                        this.on = false;
                        break;
                    }
                    if (this.on) break;
                    LsstMonitorPlugin.this.app.getCommandTargetManager().add((CommandGroup)this);
                    this.on = true;
                    break;
                }
            }
        }

        private MonitorDisplay findMonitorDisplay(JComponent component, boolean visibleOnly) {
            Component[] cc;
            if (visibleOnly && !component.isShowing()) {
                return null;
            }
            if (component instanceof MonitorDisplay) {
                return (MonitorDisplay)((Object)component);
            }
            for (Component c : cc = component.getComponents()) {
                MonitorDisplay md;
                if (!(c instanceof JComponent) || (md = this.findMonitorDisplay((JComponent)c, visibleOnly)) == null) continue;
                return md;
            }
            return null;
        }

        public void onSaveAs() {
            try {
                PageManager pm = LsstMonitorPlugin.this.app.getPageManager();
                PageContext context = pm.getSelectedPage();
                JComponent component = (JComponent)context.getPage();
                MonitorDisplay md = this.findMonitorDisplay(component, true);
                Properties user = LsstMonitorPlugin.this.app.getUserProperties();
                String creator = "creator";
                ExportDialog dlg = new ExportDialog(creator, false);
                dlg.addExportFileType((ExportFileType)new MonitorExport());
                dlg.addExportFileType((ExportFileType)new MonitorExport());
                dlg.setUserProperties(user);
                dlg.showExportDialog((Component)LsstMonitorPlugin.this.app, "Save As...", (Component)((Object)md), "monitor");
            }
            catch (ClassCastException | NullPointerException x) {
                LsstMonitorPlugin.this.app.error("No selected monitoring table", (Throwable)x);
            }
        }
    }

    public static class Descriptor
    extends ComponentDescriptor {
        private MonitorPage.Descriptor[] currentViews;
        private MonitorPage.Descriptor[] recentViews;

        public Descriptor() {
        }

        public Descriptor(ComponentDescriptor seed) {
            super(seed);
        }

        public MonitorPage.Descriptor[] getCurrentViews() {
            return this.currentViews;
        }

        public void setCurrentViews(MonitorPage.Descriptor[] currentViews) {
            this.currentViews = currentViews;
        }

        public MonitorPage.Descriptor[] getRecentViews() {
            return this.recentViews;
        }

        public void setRecentViews(MonitorPage.Descriptor[] recentViews) {
            this.recentViews = recentViews;
        }
    }
}

