/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base.filter;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.base.filter.PersistableAgentChannelsFilter;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.persist.Savable;

public interface AgentChannelsFilter
extends Savable {
    public static final String CATEGORY = "AgentChannelsFilter";
    public static final PersistableAgentChannelsFilter ALL = new AbstractChannelsFilter(){

        @Override
        public String getName() {
            return "Unfiltered";
        }
    };

    default public String getName() {
        return null;
    }

    default public List<String> getAgents() {
        return null;
    }

    default public List<String> getOriginChannels() {
        return null;
    }

    default public List<String> getDisplayChannels() {
        return null;
    }

    default public String getOriginPath(String displayPath) {
        return displayPath;
    }

    default public List<String> getOriginPaths(String displayPath) {
        String path = this.getOriginPath(displayPath);
        return path == null ? Collections.emptyList() : Collections.singletonList(path);
    }

    default public String getDisplayPath(AgentChannel channel) {
        return this.getDisplayPath(channel.getPath());
    }

    default public String getDisplayPath(String originPath) {
        return originPath;
    }

    default public List<String> getDisplayPaths(AgentChannel channel) {
        String displayPath = this.getDisplayPath(channel);
        return displayPath == null ? Collections.emptyList() : Collections.singletonList(displayPath);
    }

    default public List<String> getDisplayPaths(String originPath) {
        String displayPath = this.getDisplayPath(originPath);
        return displayPath == null ? Collections.emptyList() : Collections.singletonList(displayPath);
    }

    default public Map<String, Object> getAttributes(String path) {
        return Collections.emptyMap();
    }

    default public List<String> getFields(boolean compact) {
        return null;
    }

    public static List<String> getDisplayPath(AgentChannelsFilter filter, String originPath) {
        List<String> paths = filter.getDisplayPaths(originPath);
        if (paths.isEmpty()) {
            return paths;
        }
        List<String> dps = filter.getDisplayChannels();
        if (dps != null) {
            paths.retainAll(dps);
        }
        List<String> agents = filter.getAgents();
        List<String> channels = filter.getOriginChannels();
        int i = originPath.indexOf("/");
        if (i == -1) {
            return Collections.emptyList();
        }
        String agent = originPath.substring(0, i);
        if (channels == null) {
            if (agents == null || agents.contains(agent)) {
                return paths;
            }
        } else {
            for (String channel : channels) {
                if (AgentChannelsFilter.isSelector(channel) || agents != null && channel.startsWith("/") && !agents.contains(agent) || !AgentChannelsFilter.matchTemplate(originPath, channel)) continue;
                return paths;
            }
        }
        return Collections.emptyList();
    }

    public static boolean matchTemplate(String path, String template) {
        if (template.startsWith("/")) {
            path = path.substring(path.indexOf("/"));
        }
        return template.endsWith("/") ? path.startsWith(template) : path.equals(template);
    }

    public static boolean isSelector(String code) {
        if (code.contains("=")) {
            return true;
        }
        return !code.contains("/");
    }
}

