/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.utility.data.UtilityState;

public class UTMonitorPanel
extends JPanel
implements CommandSender.ReplyHandler {
    static final Font FONT = new Font("Tahoma", 1, 12);
    static final Color RED = new Color(150, 0, 0);
    static final Color GREEN = new Color(0, 150, 0);
    private final CommandSender gui;
    private double mainPeriod = 5.0;
    private double loopGain = 0.0;
    private double loopTimeConst = 0.0;
    private double dutyCycle = 0.0;
    private double coldTemp = 0.0;
    private final JPanel mainPanel = new JPanel();
    private final JLabel stateLabel = new JLabel("Utility State: ");
    private final JLabel stateStatus = new JLabel("STOPPED");
    private final JPanel periodPanel = new JPanel();
    private final JLabel periodLabel = new JLabel("Update Period: ");
    private final JTextField periodTextField = new JTextField();
    private final JLabel periodUnitsLabel = new JLabel("sec");
    private final JLabel gainLabel = new JLabel("Loop gain: ");
    private final JTextField gainTextField = new JTextField();
    private final JPanel timePanel = new JPanel();
    private final JLabel timeLabel = new JLabel("Time constant: ");
    private final JTextField timeTextField = new JTextField();
    private final JLabel timeUnitsLabel = new JLabel("sec");
    private final JLabel fanControlLabel = new JLabel("Fan Control: ");
    private final JLabel fanControlStatus = new JLabel("OFF");
    private final ButtonGroup fanControlBG = new ButtonGroup();
    private final JRadioButton fanControlOffRB = new JRadioButton("Off");
    private final JRadioButton fanControlManualRB = new JRadioButton("Manual");
    private final JRadioButton fanControlAutoRB = new JRadioButton("Auto");
    private final JPanel dutyPanel = new JPanel();
    private final JTextField dutyTextField = new JTextField();
    private final JPanel tempPanel = new JPanel();
    private final JTextField tempTextField = new JTextField();
    private final JLabel tempUnitsLabel = new JLabel("\u00b0C");
    private static final long serialVersionUID = 1L;

    public UTMonitorPanel(String subsys) {
        this.gui = new CommandSender(subsys, (CommandSender.ReplyHandler)this);
        this.initComponents();
        new UpdateUTState(new UtilityState()).run();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.gui.sendCommand(true, null, "getSystemState", new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((UtilityState)reply);
    }

    public void updatePanel(UtilityState rs) {
        SwingUtilities.invokeLater(new UpdateUTState(rs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        this.stateLabel.setFont(FONT);
        this.stateStatus.setFont(FONT);
        Dimension d = this.stateStatus.getPreferredSize();
        d.width = 75;
        this.stateStatus.setMinimumSize(d);
        this.stateStatus.setPreferredSize(d);
        this.periodLabel.setFont(FONT);
        d = this.periodTextField.getPreferredSize();
        d.width = 45;
        this.periodTextField.setMinimumSize(d);
        this.periodTextField.setPreferredSize(d);
        this.periodTextField.setHorizontalAlignment(0);
        this.periodTextField.setText("...");
        this.periodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UTMonitorPanel.this.setUpdatePeriod();
            }
        });
        this.periodUnitsLabel.setFont(FONT);
        this.gainLabel.setFont(FONT);
        d = this.gainTextField.getPreferredSize();
        d.width = 45;
        this.gainTextField.setMinimumSize(d);
        this.gainTextField.setPreferredSize(d);
        this.gainTextField.setHorizontalAlignment(0);
        this.gainTextField.setText("...");
        this.gainTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UTMonitorPanel.this.setLoopGain();
            }
        });
        this.timeLabel.setFont(FONT);
        d = this.timeTextField.getPreferredSize();
        d.width = 60;
        this.timeTextField.setMinimumSize(d);
        this.timeTextField.setPreferredSize(d);
        this.timeTextField.setHorizontalAlignment(0);
        this.timeTextField.setText("...");
        this.timeTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UTMonitorPanel.this.setLoopTimeConst();
            }
        });
        this.timeUnitsLabel.setFont(FONT);
        this.fanControlLabel.setFont(FONT);
        this.fanControlStatus.setFont(FONT);
        d = this.fanControlStatus.getPreferredSize();
        d.width = 60;
        this.fanControlStatus.setMinimumSize(d);
        this.fanControlStatus.setPreferredSize(d);
        this.fanControlOffRB.setFont(FONT);
        this.fanControlOffRB.setFocusable(false);
        this.fanControlOffRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UTMonitorPanel.this.setControlState(0);
            }
        });
        this.fanControlManualRB.setFont(FONT);
        this.fanControlManualRB.setFocusable(false);
        this.fanControlManualRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UTMonitorPanel.this.setControlState(1);
            }
        });
        this.fanControlAutoRB.setFont(FONT);
        this.fanControlAutoRB.setFocusable(false);
        this.fanControlAutoRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UTMonitorPanel.this.setControlState(2);
            }
        });
        this.fanControlBG.add(this.fanControlOffRB);
        this.fanControlBG.add(this.fanControlManualRB);
        this.fanControlBG.add(this.fanControlAutoRB);
        d = this.dutyTextField.getPreferredSize();
        d.width = 50;
        this.dutyTextField.setMinimumSize(d);
        this.dutyTextField.setPreferredSize(d);
        this.dutyTextField.setHorizontalAlignment(0);
        this.dutyTextField.setText("...");
        this.dutyTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UTMonitorPanel.this.setControlDuty();
            }
        });
        d = this.tempTextField.getPreferredSize();
        d.width = 60;
        this.tempTextField.setMinimumSize(d);
        this.tempTextField.setPreferredSize(d);
        this.tempTextField.setHorizontalAlignment(0);
        this.tempTextField.setText("...");
        this.tempTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UTMonitorPanel.this.setControlTemp();
            }
        });
        this.tempUnitsLabel.setFont(FONT);
        this.periodPanel.add(this.periodTextField);
        this.periodPanel.add(this.periodUnitsLabel);
        this.timePanel.add(this.timeTextField);
        this.timePanel.add(this.timeUnitsLabel);
        this.dutyPanel.add(this.dutyTextField);
        this.tempPanel.add(this.tempTextField);
        this.tempPanel.add(this.tempUnitsLabel);
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(5, 0, 5, 0);
        gbm.gridx = 0;
        gbm.gridy = 0;
        gbm.anchor = 13;
        this.mainPanel.add((Component)this.stateLabel, gbm);
        ++gbm.gridx;
        gbm.anchor = 17;
        this.mainPanel.add((Component)this.stateStatus, gbm);
        ++gbm.gridx;
        gbm.gridwidth = 2;
        gbm.anchor = 13;
        this.mainPanel.add((Component)this.periodLabel, gbm);
        gbm.gridx += 2;
        gbm.gridwidth = 1;
        gbm.anchor = 17;
        this.mainPanel.add((Component)this.periodPanel, gbm);
        gbm.gridx = 0;
        ++gbm.gridy;
        gbm.anchor = 13;
        gbm.insets.top = -4;
        this.mainPanel.add((Component)this.gainLabel, gbm);
        ++gbm.gridx;
        gbm.anchor = 17;
        this.mainPanel.add((Component)this.gainTextField, gbm);
        ++gbm.gridx;
        gbm.gridwidth = 2;
        gbm.anchor = 13;
        this.mainPanel.add((Component)this.timeLabel, gbm);
        gbm.gridx += 2;
        gbm.gridwidth = 1;
        gbm.anchor = 17;
        this.mainPanel.add((Component)this.timePanel, gbm);
        gbm.gridx = 0;
        ++gbm.gridy;
        gbm.insets.top = 0;
        gbm.anchor = 12;
        this.mainPanel.add((Component)this.fanControlLabel, gbm);
        ++gbm.gridx;
        gbm.anchor = 18;
        this.mainPanel.add((Component)this.fanControlStatus, gbm);
        ++gbm.gridx;
        gbm.insets.top = -4;
        this.mainPanel.add((Component)this.fanControlOffRB, gbm);
        ++gbm.gridx;
        gbm.insets.left = 6;
        this.mainPanel.add((Component)this.fanControlManualRB, gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)this.fanControlAutoRB, gbm);
        gbm.gridx = 0;
        ++gbm.gridy;
        gbm.insets.top = -10;
        gbm.insets.left = 6;
        gbm.gridx = 3;
        this.mainPanel.add((Component)this.dutyPanel, gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)this.tempPanel, gbm);
        this.add(this.mainPanel);
    }

    private void setUpdatePeriod() {
        try {
            double value = Double.valueOf(this.periodTextField.getText());
            this.gui.sendCommand(null, "setUpdatePeriod", new Object[]{(int)(1000.0 * value)});
            this.periodTextField.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.periodTextField.setText(String.valueOf(this.mainPeriod));
        }
    }

    private void setLoopGain() {
        try {
            double value = Double.valueOf(this.gainTextField.getText());
            this.gui.sendCommand(null, "setGain", new Object[]{value});
            this.gainTextField.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.gainTextField.setText(String.valueOf(this.loopGain));
        }
    }

    private void setLoopTimeConst() {
        try {
            double value = Double.valueOf(this.timeTextField.getText());
            this.gui.sendCommand(null, "setTimeConstant", new Object[]{value});
            this.timeTextField.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.timeTextField.setText(String.valueOf(this.loopTimeConst));
        }
    }

    private void setControlState(int value) {
        this.fanControlOffRB.setEnabled(false);
        this.fanControlManualRB.setEnabled(false);
        this.fanControlAutoRB.setEnabled(false);
        this.gui.sendCommand(null, "setControlState", new Object[]{value});
    }

    private void setControlDuty() {
        try {
            double value = Double.valueOf(this.dutyTextField.getText());
            this.gui.sendCommand(null, "setFanSpeed", new Object[]{value});
            this.dutyTextField.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.dutyTextField.setText(String.valueOf(this.dutyCycle));
        }
    }

    private void setControlTemp() {
        try {
            double value = Double.valueOf(this.tempTextField.getText());
            this.gui.sendCommand(null, "setColdTemp", new Object[]{value});
            this.tempTextField.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.tempTextField.setText(String.valueOf(this.coldTemp));
        }
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            UTMonitorPanel.this.stateStatus.setText("STOPPED");
            UTMonitorPanel.this.stateStatus.setForeground(RED);
            UTMonitorPanel.this.periodTextField.setEnabled(false);
            UTMonitorPanel.this.gainTextField.setEnabled(false);
            UTMonitorPanel.this.timeTextField.setEnabled(false);
            UTMonitorPanel.this.fanControlStatus.setEnabled(false);
            UTMonitorPanel.this.fanControlOffRB.setEnabled(false);
            UTMonitorPanel.this.fanControlManualRB.setEnabled(false);
            UTMonitorPanel.this.fanControlAutoRB.setEnabled(false);
            UTMonitorPanel.this.dutyTextField.setEnabled(false);
            UTMonitorPanel.this.tempTextField.setEnabled(false);
        }
    }

    class UpdateUTState
    implements Runnable {
        private final UtilityState us;

        UpdateUTState(UtilityState us) {
            this.us = us;
        }

        @Override
        public void run() {
            UTMonitorPanel.this.stateStatus.setText("RUNNING");
            UTMonitorPanel.this.stateStatus.setForeground(GREEN);
            UTMonitorPanel.this.periodTextField.setEnabled(true);
            UTMonitorPanel.this.mainPeriod = (double)this.us.getTickMillis() / 1000.0;
            UTMonitorPanel.this.periodTextField.setText(String.valueOf(UTMonitorPanel.this.mainPeriod));
            UTMonitorPanel.this.gainTextField.setEnabled(true);
            UTMonitorPanel.this.loopGain = this.us.getLoopGain();
            UTMonitorPanel.this.gainTextField.setText(String.valueOf(UTMonitorPanel.this.loopGain));
            UTMonitorPanel.this.timeTextField.setEnabled(true);
            UTMonitorPanel.this.loopTimeConst = this.us.getLoopTimeConst();
            UTMonitorPanel.this.timeTextField.setText(String.valueOf(UTMonitorPanel.this.loopTimeConst));
            int state = this.us.getOpState();
            UTMonitorPanel.this.fanControlStatus.setEnabled(true);
            UTMonitorPanel.this.fanControlStatus.setText(state == 1 ? "MANUAL" : (state == 2 ? "AUTO" : "OFF"));
            UTMonitorPanel.this.fanControlStatus.setForeground(state == 1 ? GREEN : (state == 2 ? RED : Color.black));
            JRadioButton selButton = state == 1 ? UTMonitorPanel.this.fanControlManualRB : (state == 2 ? UTMonitorPanel.this.fanControlAutoRB : UTMonitorPanel.this.fanControlOffRB);
            selButton.setSelected(true);
            UTMonitorPanel.this.fanControlOffRB.setEnabled(selButton != UTMonitorPanel.this.fanControlOffRB);
            UTMonitorPanel.this.fanControlManualRB.setEnabled(selButton != UTMonitorPanel.this.fanControlManualRB);
            UTMonitorPanel.this.fanControlAutoRB.setEnabled(selButton != UTMonitorPanel.this.fanControlAutoRB);
            UTMonitorPanel.this.dutyTextField.setEnabled(true);
            UTMonitorPanel.this.dutyCycle = this.us.getDutyCycle();
            UTMonitorPanel.this.dutyTextField.setText(String.valueOf(UTMonitorPanel.this.dutyCycle));
            UTMonitorPanel.this.tempTextField.setEnabled(true);
            UTMonitorPanel.this.coldTemp = this.us.getCoolTemp();
            UTMonitorPanel.this.tempTextField.setText(String.valueOf(UTMonitorPanel.this.coldTemp));
        }
    }
}

