package org.lsst.ccs.subsystem.utility.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.MonOptionalPage;
import org.lsst.ccs.subsystem.utility.constants.UtilityAgentProperties;
import org.lsst.ccs.subsystem.utility.data.UtilTrunkState;
import org.lsst.ccs.subsystem.utility.ui.UtilTrunkControlPanel;

/**
 * @author tonyj
 */
@Plugin(name = "Utility Trunk Control Plugin", description = "Utility Trunk Control Plugin")
public class UtilTrunkControlPlugin extends ConsolePlugin {

    @Override
    public void initialize() {
        OptionalPage.getService().add(new MonOptionalPage(UtilityAgentProperties.UTIL_TRUNK_TYPE, UtilTrunkControl.class, "Control", true));
        OptionalPage.getService().add(new MonOptionalPage(UtilityAgentProperties.UTIL_TRUNK_TYPE, null, "Monitor", true));
    }
    
    public static class UtilTrunkControl extends ControlPanel implements StatusMessageListener {

        private UtilTrunkControlPanel ctrlPanel;
        
        @Override
        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals(UtilTrunkState.KEY)) {
                    updateControlPanel(((KeyValueData)sd.getSubsystemData()).getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException x) {
            }
        }

        @Override
        public JPanel getControlPanel(String agent) {
            return ctrlPanel = new UtilTrunkControlPanel(agent);
        }

        @Override
        public void initControlPanel() {
            ctrlPanel.initPanel();
        }

        @Override
        public void updateControlPanel(Object obj) {
            ctrlPanel.updatePanel((UtilTrunkState)obj);
        }

        @Override
        public void disableControlPanel() {
            ctrlPanel.disablePanel();
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
    
}
