package org.lsst.ccs.subsystem.utility.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.MonOptionalPage;
import org.lsst.ccs.subsystem.utility.constants.UtilityAgentProperties;
import org.lsst.ccs.subsystem.utility.data.UTTestState;
import org.lsst.ccs.subsystem.utility.ui.UTTestControlPanel;

/**
 * @author tonyj
 */
@Plugin(name = "Utility Trunk Test Control Plugin", description = "Utility Trunk Test Control Plugin")
public class UTTestControlPlugin extends ConsolePlugin {

    @Override
    public void initialize() {
        OptionalPage optPage = new MonOptionalPage(UtilityAgentProperties.UT_TEST_TYPE, UTTestControl.class,
                                                   null, true, "UTTestState");
        Console.getConsole().getOptionalPageService().add(optPage);
    }
    
    public static class UTTestControl extends ControlPanel implements StatusMessageListener {

        private UTTestControlPanel ctrlPanel;
        
        @Override
        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals(UTTestState.KEY)) {
                    updateControlPanel(((KeyValueData)sd.getSubsystemData()).getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException x) {
            }
        }

        @Override
        public JPanel getControlPanel(String agent) {
            return ctrlPanel = new UTTestControlPanel(agent);
        }

        @Override
        public void initControlPanel() {
            ctrlPanel.initPanel();
        }

        @Override
        public void updateControlPanel(Object obj) {
            ctrlPanel.updatePanel((UTTestState)obj);
        }

        @Override
        public void disableControlPanel() {
            ctrlPanel.disablePanel();
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
    
}
