package org.lsst.ccs.subsystem.utility.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.MonOptionalPage;
import org.lsst.ccs.subsystem.utility.constants.UtilityAgentProperties;
import org.lsst.ccs.subsystem.utility.data.PurgeTestState;
import org.lsst.ccs.subsystem.utility.ui.PurgeTestControlPanel;

/**
 * @author tonyj
 */
@Plugin(name = "Purge Test Control Plugin", description = "Purge Test Control Plugin")
public class PurgeTestControlPlugin extends ConsolePlugin {

    @Override
    public void initialize() {
        OptionalPage optPage = new MonOptionalPage(UtilityAgentProperties.PURGE_TEST_TYPE, PurgeTestControl.class,
                                                   null, true, "PurgeTestState");
        Console.getConsole().getOptionalPageService().add(optPage);
    }
    
    public static class PurgeTestControl extends ControlPanel implements StatusMessageListener {

        private CommandSender cmdSender;
        private PurgeTestControlPanel ctrlPanel;
        
        @Override
        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals(PurgeTestState.KEY)) {
                    updateControlPanel(((KeyValueData)sd.getSubsystemData()).getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException x) {
            }
        }

        @Override
        public JPanel getControlPanel(CommandSender sndr) {
            cmdSender = sndr;
            return ctrlPanel = new PurgeTestControlPanel(sndr);
        }

        @Override
        public void initControlPanel() {
            updateControlPanel(cmdSender.sendCommand(null, "getFullState"));
        }

        @Override
        public void updateControlPanel(Object obj) {
            ctrlPanel.updateControlPanel((PurgeTestState)obj);
        }

        @Override
        public void disableSystem() {
            ctrlPanel.disableSystem();
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
    
}
