/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.data;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.subsystem.utility.constants.ConditionState;
import org.lsst.ccs.subsystem.utility.constants.LatchState;
import org.lsst.ccs.subsystem.utility.constants.PLCState;
import org.lsst.ccs.subsystem.utility.constants.SwitchState;

public class MpmSysState
implements Serializable {
    public static final String KEY = "MPMState";
    private int tickMillis;
    private final PLCState[] plcState = new PLCState[3];
    private final SwitchState[] switchState = new SwitchState[7];
    private final LatchState[] latchState = new LatchState[11];
    private final ConditionState[] conditionState = new ConditionState[7];
    private final int[] tempLimit = new int[4];
    private static final long serialVersionUID = -5524875121139066984L;

    public MpmSysState() {
        Arrays.fill((Object[])this.plcState, (Object)PLCState.ALIVE);
        Arrays.fill((Object[])this.switchState, (Object)SwitchState.OFFLINE);
        Arrays.fill((Object[])this.latchState, (Object)LatchState.OFFLINE);
        Arrays.fill((Object[])this.conditionState, (Object)ConditionState.OFF);
        Arrays.fill(this.tempLimit, Integer.MAX_VALUE);
    }

    public void setTickMillis(int value) {
        this.tickMillis = value;
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setPlcState(int plc, PLCState value) {
        this.plcState[plc] = value;
    }

    public PLCState getPlcState(int plc) {
        return this.plcState[plc];
    }

    public void setSwitchState(int sw, SwitchState state) {
        this.switchState[sw] = state;
    }

    public SwitchState getSwitchState(int sw) {
        return this.switchState[sw];
    }

    public void setLatch(int latch, LatchState state) {
        this.latchState[latch] = state;
    }

    public LatchState getLatch(int latch) {
        return this.latchState[latch];
    }

    public void setCondition(int cond, ConditionState state) {
        this.conditionState[cond] = state;
    }

    public ConditionState getCondition(int cond) {
        return this.conditionState[cond];
    }

    public void setLimit(int limit, int value) {
        this.tempLimit[limit] = value;
    }

    public int getLimit(int limit) {
        return this.tempLimit[limit];
    }
}

