/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.MonOptionalPage;
import org.lsst.ccs.subsystem.utility.data.PurgeTestState;
import org.lsst.ccs.subsystem.utility.ui.PurgeTestControlPanel;

@Plugin(name="Purge Test Control Plugin", description="Purge Test Control Plugin")
public class PurgeTestControlPlugin
extends ConsolePlugin {
    public void initialize() {
        MonOptionalPage optPage = new MonOptionalPage("purgeTestType", PurgeTestControl.class, null, true, new String[]{"PurgeTestState"});
        Console.getConsole().getOptionalPageService().add((OptionalPage)optPage);
    }

    public static class PurgeTestControl
    extends ControlPanel
    implements StatusMessageListener {
        private CommandSender cmdSender;
        private PurgeTestControlPanel ctrlPanel;

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("PurgeTestState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        public JPanel getControlPanel(CommandSender sndr) {
            this.cmdSender = sndr;
            this.ctrlPanel = new PurgeTestControlPanel(sndr);
            return this.ctrlPanel;
        }

        public void initControlPanel() {
            this.updateControlPanel(this.cmdSender.sendCommand(null, "getFullState", new Object[0]));
        }

        public void updateControlPanel(Object obj) {
            this.ctrlPanel.updateControlPanel((PurgeTestState)obj);
        }

        public void disableSystem() {
            this.ctrlPanel.disableSystem();
        }

        public StatusMessageListener getListener() {
            return this;
        }
    }
}

