/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.utility.constants.ConditionState;
import org.lsst.ccs.subsystem.utility.constants.LatchState;
import org.lsst.ccs.subsystem.utility.constants.MpmLatches;
import org.lsst.ccs.subsystem.utility.constants.MpmSwitches;
import org.lsst.ccs.subsystem.utility.constants.PLCState;
import org.lsst.ccs.subsystem.utility.constants.SwitchState;
import org.lsst.ccs.subsystem.utility.data.MpmSysState;

public class MpmControlPanel
extends JPanel {
    private static final String[] plcNames = new String[3];
    private static final String[] switchNames;
    private static final String[] latchNames;
    private static final String[] conditionNames;
    private static final int plcStateWidth;
    private static final int switchStateWidth;
    private static final int latchStateWidth;
    private static final int conditionStateWidth;
    private SystemStatusPanel systemPanel;
    private JPanel plcPanel;
    private final JLabel[] plcLabel = new JLabel[3];
    private final JLabel[] plcStatus = new JLabel[3];
    private JPanel switchPanel;
    private final JLabel[] switchLabel = new JLabel[7];
    private final JLabel[] switchStatus = new JLabel[7];
    private final ButtonGroup[] switchBG = new ButtonGroup[7];
    private final JRadioButton[] switchOffRB = new JRadioButton[7];
    private final JRadioButton[] switchOnRB = new JRadioButton[7];
    private JPanel latchPanel;
    private final JLabel[] latchLabel = new JLabel[11];
    private final JLabel[] latchStatus = new JLabel[11];
    private final JButton[] latchResetBtn = new JButton[11];
    private JPanel conditionPanel;
    private final JLabel[] conditionLabel = new JLabel[7];
    private final JLabel[] conditionStatus = new JLabel[7];
    private final CommandSender sender;
    private boolean gotTempLimits = false;
    private static final long serialVersionUID = 1L;

    public MpmControlPanel(CommandSender cons) {
        this.sender = cons;
        this.initComponents();
        new UpdateSysStatus(new MpmSysState()).run();
        new DisableSystem().run();
    }

    private void initComponents() {
        int cond;
        this.systemPanel = new SystemStatusPanel(this.sender);
        for (int plc = 0; plc < 3; ++plc) {
            this.plcLabel[plc] = MpmControlPanel.newLabel(plcNames[plc] + ":", 0);
            this.plcStatus[plc] = MpmControlPanel.newLabel("XXX", plcStateWidth);
        }
        for (int sw = 0; sw < 7; ++sw) {
            this.switchLabel[sw] = MpmControlPanel.newLabel(switchNames[sw] + ":", 0);
            this.switchStatus[sw] = MpmControlPanel.newLabel("XXX", switchStateWidth);
            this.switchOffRB[sw] = this.newRadioButton("Off", "XF" + sw);
            this.switchOnRB[sw] = this.newRadioButton("On", "XT" + sw);
            ButtonGroup bg = this.switchBG[sw] = new ButtonGroup();
            bg.add(this.switchOffRB[sw]);
            bg.add(this.switchOnRB[sw]);
        }
        for (cond = 0; cond < 11; ++cond) {
            this.latchLabel[cond] = MpmControlPanel.newLabel(latchNames[cond] + ":", 0);
            this.latchStatus[cond] = MpmControlPanel.newLabel("XXX", latchStateWidth);
            this.latchResetBtn[cond] = this.newButton("Reset", "XX" + cond);
        }
        for (cond = 0; cond < 7; ++cond) {
            this.conditionLabel[cond] = MpmControlPanel.newLabel(conditionNames[cond] + ":", 0);
            this.conditionStatus[cond] = MpmControlPanel.newLabel("XXX", conditionStateWidth);
        }
        this.plcPanel = MpmControlPanel.newBorderedPanel("PLC States");
        GridBagConstraints gbp = new GridBagConstraints();
        gbp.anchor = 18;
        gbp.gridx = 0;
        gbp.gridy = 0;
        gbp.insets = new Insets(4, 5, 4, 5);
        for (int plc = 0; plc < 3; ++plc) {
            this.addPlcLine(plc, this.plcPanel, gbp);
            gbp.insets.left = 35;
        }
        this.switchPanel = MpmControlPanel.newBorderedPanel("Switches");
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = 18;
        gbs.gridy = 0;
        int numColm = 2;
        int colm = 0;
        for (int sw = 0; sw < 7; ++sw) {
            if (colm == 0) {
                gbs.gridx = 0;
                ++gbs.gridy;
            }
            gbs.insets.top = sw < numColm ? 4 : 0;
            gbs.insets.left = colm == 0 ? 5 : 40;
            this.addSwitchLine(sw, this.switchPanel, gbs);
            colm = (colm + 1) % numColm;
        }
        this.latchPanel = MpmControlPanel.newBorderedPanel("PLC Error Conditions");
        GridBagConstraints gbl = new GridBagConstraints();
        gbl.anchor = 18;
        gbl.insets.bottom = 4;
        gbl.gridy = 0;
        numColm = 2;
        colm = 0;
        for (int cond2 = 0; cond2 < 11; ++cond2) {
            if (colm == 0) {
                gbl.gridx = 0;
                ++gbl.gridy;
            }
            gbl.insets.top = cond2 < numColm ? 4 : 0;
            gbl.insets.left = colm == 0 ? 5 : 40;
            this.addLatchLine(cond2, this.latchPanel, gbl);
            colm = (colm + 1) % numColm;
        }
        this.conditionPanel = MpmControlPanel.newBorderedPanel("PLC Running Conditions");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 0, 4, 5);
        gbc.gridy = 0;
        numColm = 2;
        colm = 0;
        for (int cond3 = 0; cond3 < 7; ++cond3) {
            if (colm == 0) {
                gbc.gridx = 0;
                ++gbc.gridy;
            }
            gbc.insets.top = cond3 < numColm ? 4 : 0;
            gbc.insets.left = colm == 0 ? 5 : 35;
            this.addConditionLine(cond3, this.conditionPanel, gbc);
            colm = (colm + 1) % numColm;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.add((Component)this.systemPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.plcPanel, gbm);
        ++gbm.gridy;
        gbm.insets.top = 6;
        this.add((Component)this.switchPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.latchPanel, gbm);
        ++gbm.gridy;
        gbm.insets.bottom = 6;
        this.add((Component)this.conditionPanel, gbm);
    }

    private static JLabel newLabel(String text, int width) {
        JLabel label = new JLabel(text);
        label.setFont(UiConstants.FONT);
        Dimension d = label.getPreferredSize();
        if (width > 0) {
            d.width = width;
        }
        label.setPreferredSize(d);
        return label;
    }

    private JRadioButton newRadioButton(String title, String name) {
        JRadioButton rb = new JRadioButton(title);
        rb.setFont(UiConstants.FONT);
        rb.setFocusable(false);
        rb.setName(name);
        rb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MpmControlPanel.this.handleRadioButton(((JRadioButton)evt.getSource()).getName());
            }
        });
        return rb;
    }

    private JButton newButton(String title, String name) {
        JButton btn = new JButton(title);
        Insets i = btn.getMargin();
        i.left -= 3;
        i.right -= 3;
        btn.setMargin(i);
        Dimension d = btn.getPreferredSize();
        d.height -= 9;
        btn.setPreferredSize(d);
        btn.setFont(UiConstants.FONT);
        btn.setFocusable(false);
        btn.setName(name);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MpmControlPanel.this.handleButton(((JButton)evt.getSource()).getName());
            }
        });
        return btn;
    }

    private static JPanel newBorderedPanel(String title) {
        JPanel panel = new JPanel();
        TitledBorder border = new TitledBorder(new LineBorder(Color.BLACK), title);
        border.setTitleJustification(2);
        border.setTitleFont(UiConstants.FONT);
        border.setTitleColor(UiConstants.BLUE);
        panel.setBorder(border);
        panel.setLayout(new GridBagLayout());
        return panel;
    }

    private void addPlcLine(int plc, JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)this.plcLabel[plc], gbc);
        ++gbc.gridx;
        gbc.insets.left = 0;
        panel.add((Component)this.plcStatus[plc], gbc);
        ++gbc.gridx;
    }

    private void addSwitchLine(int sw, JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)this.switchLabel[sw], gbc);
        gbc.insets.left = 6;
        ++gbc.gridx;
        panel.add((Component)this.switchStatus[sw], gbc);
        ++gbc.gridx;
        gbc.insets.left = 8;
        gbc.insets.top -= 4;
        panel.add((Component)this.switchOffRB[sw], gbc);
        ++gbc.gridx;
        gbc.insets.left = 3;
        gbc.insets.right = 3;
        panel.add((Component)this.switchOnRB[sw], gbc);
        ++gbc.gridx;
        gbc.insets.right = 0;
    }

    private void addLatchLine(int cond, JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)this.latchLabel[cond], gbc);
        gbc.insets.left = 5;
        ++gbc.gridx;
        panel.add((Component)this.latchStatus[cond], gbc);
        ++gbc.gridx;
        --gbc.insets.top;
        gbc.insets.right = 4;
        panel.add((Component)this.latchResetBtn[cond], gbc);
        gbc.insets.right = 0;
        ++gbc.gridx;
    }

    private void addConditionLine(int cond, JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)this.conditionLabel[cond], gbc);
        gbc.insets.left = 0;
        ++gbc.gridx;
        panel.add((Component)this.conditionStatus[cond], gbc);
        ++gbc.gridx;
    }

    private void handleRadioButton(String name) {
        char type = name.charAt(0);
        char action = name.charAt(1);
        String swName = MpmSwitches.ID_MAP.get(Integer.valueOf(name.substring(2, 3)));
        this.sender.sendCommand(null, "setNamedSwitchOn", new Object[]{swName, action == 'T'});
    }

    private void handleButton(String name) {
        char type = name.charAt(0);
        char action = name.charAt(1);
        String lName = MpmLatches.ID_MAP.get(Integer.valueOf(name.substring(2, 3)));
        this.sender.sendCommand(null, "clearLatch", new Object[]{lName});
    }

    public void updateControlPanel(MpmSysState rs) {
        SwingUtilities.invokeLater(new UpdateSysStatus(rs));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    static {
        MpmControlPanel.plcNames[0] = "Trunk";
        MpmControlPanel.plcNames[1] = "Cold";
        MpmControlPanel.plcNames[2] = "Cryo";
        switchNames = new String[7];
        MpmControlPanel.switchNames[4] = "Block Cold Heater";
        MpmControlPanel.switchNames[3] = "Block Cold Refrig";
        MpmControlPanel.switchNames[6] = "Block Cryo Heater";
        MpmControlPanel.switchNames[5] = "Block Cryo Refrig";
        MpmControlPanel.switchNames[2] = "Block UT Coolant";
        MpmControlPanel.switchNames[1] = "Block REB Power";
        MpmControlPanel.switchNames[0] = "Block UT Power";
        latchNames = new String[11];
        MpmControlPanel.latchNames[5] = "Cold Temp > 99C";
        MpmControlPanel.latchNames[6] = "Cold Temp < -99C";
        MpmControlPanel.latchNames[7] = "Cryo Temp > 99C";
        MpmControlPanel.latchNames[8] = "Cryo Temp < -999C";
        MpmControlPanel.latchNames[9] = "Cryo Vacuum Bad";
        MpmControlPanel.latchNames[10] = "Hex Vacuum Bad";
        MpmControlPanel.latchNames[1] = "UT Leak";
        MpmControlPanel.latchNames[2] = "UT Leak Fault";
        MpmControlPanel.latchNames[3] = "UT Smoke";
        MpmControlPanel.latchNames[4] = "UT Smoke Fault";
        MpmControlPanel.latchNames[0] = "UT Temp High";
        conditionNames = new String[7];
        MpmControlPanel.conditionNames[0] = "UT Power Permit";
        MpmControlPanel.conditionNames[1] = "REB Power Permit";
        MpmControlPanel.conditionNames[2] = "UT Coolant Permit";
        MpmControlPanel.conditionNames[3] = "Cold Refrig Permit";
        MpmControlPanel.conditionNames[4] = "Cold Heater Permit";
        MpmControlPanel.conditionNames[5] = "Cryo Refrig Permit";
        MpmControlPanel.conditionNames[6] = "Cryo Heater Permit";
        JLabel label = new JLabel();
        label.setFont(UiConstants.FONT);
        int width = 0;
        for (PLCState pLCState : PLCState.values()) {
            label.setText(pLCState.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        plcStateWidth = width;
        width = 0;
        for (Enum enum_ : SwitchState.values()) {
            label.setText(enum_.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        switchStateWidth = width;
        width = 0;
        for (Enum enum_ : LatchState.values()) {
            label.setText(enum_.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        latchStateWidth = width;
        width = 0;
        for (Enum enum_ : ConditionState.values()) {
            label.setText(enum_.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        conditionStateWidth = width;
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            int cond;
            MpmControlPanel.this.systemPanel.disableSystem();
            for (int plc = 0; plc < 3; ++plc) {
                MpmControlPanel.this.plcStatus[plc].setEnabled(false);
            }
            for (int sw = 0; sw < 7; ++sw) {
                MpmControlPanel.this.switchStatus[sw].setEnabled(false);
                MpmControlPanel.this.switchOffRB[sw].setEnabled(false);
                MpmControlPanel.this.switchOnRB[sw].setEnabled(false);
            }
            for (cond = 0; cond < 11; ++cond) {
                MpmControlPanel.this.latchStatus[cond].setEnabled(false);
                MpmControlPanel.this.latchResetBtn[cond].setEnabled(false);
            }
            for (cond = 0; cond < 7; ++cond) {
                MpmControlPanel.this.conditionStatus[cond].setEnabled(false);
            }
            MpmControlPanel.this.repaint();
        }
    }

    class UpdateSysStatus
    implements Runnable {
        private final MpmSysState ps;

        UpdateSysStatus(MpmSysState ps) {
            this.ps = ps;
        }

        @Override
        public void run() {
            int cond;
            Enum state;
            MpmControlPanel.this.systemPanel.updateStatus(this.ps.getTickMillis());
            for (int plc = 0; plc < 3; ++plc) {
                state = this.ps.getPlcState(plc);
                MpmControlPanel.this.plcStatus[plc].setText(state.name());
                MpmControlPanel.this.plcStatus[plc].setForeground(state == PLCState.OFFLINE ? UiConstants.BLUE : (state == PLCState.DEAD ? UiConstants.RED : UiConstants.GREEN));
                MpmControlPanel.this.plcStatus[plc].setEnabled(true);
            }
            for (int sw = 0; sw < 7; ++sw) {
                state = this.ps.getSwitchState(sw);
                String text = state.name();
                Color color = state == SwitchState.OFF ? Color.black : (state == SwitchState.ON ? UiConstants.GREEN : UiConstants.BLUE);
                MpmControlPanel.this.switchStatus[sw].setText(text);
                MpmControlPanel.this.switchStatus[sw].setForeground(color);
                JRadioButton selButton = state == SwitchState.ON ? MpmControlPanel.this.switchOnRB[sw] : MpmControlPanel.this.switchOffRB[sw];
                selButton.setSelected(true);
                MpmControlPanel.this.switchStatus[sw].setEnabled(true);
                MpmControlPanel.this.switchOffRB[sw].setEnabled(true);
                MpmControlPanel.this.switchOnRB[sw].setEnabled(true);
            }
            for (cond = 0; cond < 11; ++cond) {
                state = this.ps.getLatch(cond);
                MpmControlPanel.this.latchStatus[cond].setText(state.name());
                MpmControlPanel.this.latchStatus[cond].setForeground(state == LatchState.OFFLINE ? UiConstants.BLUE : (state == LatchState.CLEAR ? UiConstants.GREEN : (state == LatchState.ACTIVE ? UiConstants.RED : UiConstants.PURPLE)));
                MpmControlPanel.this.latchStatus[cond].setEnabled(true);
                MpmControlPanel.this.latchResetBtn[cond].setEnabled(true);
            }
            for (cond = 0; cond < 7; ++cond) {
                state = this.ps.getCondition(cond);
                MpmControlPanel.this.conditionStatus[cond].setText(state.name());
                MpmControlPanel.this.conditionStatus[cond].setForeground(state == ConditionState.OFF ? UiConstants.BLUE : (state == ConditionState.NO ? Color.BLACK : UiConstants.GREEN));
                MpmControlPanel.this.conditionStatus[cond].setEnabled(true);
            }
            if (!MpmControlPanel.this.gotTempLimits && this.ps.getLimit(0) != Integer.MAX_VALUE) {
                MpmControlPanel.this.latchLabel[5].setText("Cold Temp > " + this.ps.getLimit(1) + "C:");
                MpmControlPanel.this.latchLabel[6].setText("Cold Temp < " + this.ps.getLimit(0) + "C:");
                MpmControlPanel.this.latchLabel[7].setText("Cryo Temp > " + this.ps.getLimit(3) + "C:");
                MpmControlPanel.this.latchLabel[8].setText("Cryo Temp < " + this.ps.getLimit(2) + "C:");
                MpmControlPanel.this.gotTempLimits = true;
            }
            MpmControlPanel.this.repaint();
        }
    }
}

