/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.utility.constants.ConditionState;
import org.lsst.ccs.subsystem.utility.constants.LatchState;
import org.lsst.ccs.subsystem.utility.constants.PLCState;
import org.lsst.ccs.subsystem.utility.constants.SwitchState;
import org.lsst.ccs.subsystem.utility.data.MpmSysState;

public class MpmControlPanel
extends JPanel {
    static final int SWTP_PUMP = 0;
    static final int SWTP_VALVE = 1;
    static final String[] plcNames = new String[3];
    static final String[] switchNames;
    static final String[] latchNames;
    static final String[] conditionNames;
    static final int plcStateWidth;
    static final int switchStateWidth;
    static final int latchStateWidth;
    static final int conditionStateWidth;
    private final CommandSender sender;
    private SystemStatusPanel systemPanel;
    private final JPanel plcPanel = new JPanel();
    private final JLabel[] plcLabel = new JLabel[3];
    private final JLabel[] plcStatus = new JLabel[3];
    private final JPanel switchPanel = new JPanel();
    private final JLabel[] switchLabel = new JLabel[7];
    private final JLabel[] switchStatus = new JLabel[7];
    private final ButtonGroup[] switchBG = new ButtonGroup[7];
    private final JRadioButton[] switchOffRB = new JRadioButton[7];
    private final JRadioButton[] switchOnRB = new JRadioButton[7];
    private final JPanel latchPanel = new JPanel();
    private final JLabel[] latchLabel = new JLabel[11];
    private final JLabel[] latchStatus = new JLabel[11];
    private final JButton[] latchResetBtn = new JButton[11];
    private final JPanel conditionPanel = new JPanel();
    private final JLabel[] conditionLabel = new JLabel[7];
    private final JLabel[] conditionStatus = new JLabel[7];
    private static final long serialVersionUID = 1L;

    public MpmControlPanel(CommandSender cons) {
        this.sender = cons;
        this.initComponents();
        new UpdateSysStatus(new MpmSysState()).run();
        new DisableSystem().run();
    }

    private void initComponents() {
        int cond;
        Dimension d;
        JLabel label;
        this.systemPanel = new SystemStatusPanel(this.sender);
        for (int plc = 0; plc < 3; ++plc) {
            label = this.plcLabel[plc] = new JLabel(plcNames[plc] + ":");
            label.setFont(UiConstants.FONT);
            label = this.plcStatus[plc] = new JLabel("XXX");
            label.setFont(UiConstants.FONT);
            d = label.getPreferredSize();
            d.width = plcStateWidth;
            label.setPreferredSize(d);
        }
        for (int sw = 0; sw < 7; ++sw) {
            label = this.switchLabel[sw] = new JLabel(switchNames[sw] + ":");
            label.setFont(UiConstants.FONT);
            label = this.switchStatus[sw] = new JLabel("XXX");
            label.setFont(UiConstants.FONT);
            d = label.getPreferredSize();
            d.width = switchStateWidth;
            label.setPreferredSize(d);
            JRadioButton buttonOff = this.switchOffRB[sw] = new JRadioButton("Off");
            buttonOff.setFont(UiConstants.FONT);
            buttonOff.setFocusable(false);
            buttonOff.setName(Integer.toString(sw));
            buttonOff.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JRadioButton)evt.getSource()).getName();
                    MpmControlPanel.this.setSwitchOn(Integer.valueOf(name), false);
                }
            });
            JRadioButton buttonOn = this.switchOnRB[sw] = new JRadioButton("On");
            buttonOn.setFont(UiConstants.FONT);
            buttonOn.setFocusable(false);
            buttonOn.setName(Integer.toString(sw));
            buttonOn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JRadioButton)evt.getSource()).getName();
                    MpmControlPanel.this.setSwitchOn(Integer.valueOf(name), true);
                }
            });
            ButtonGroup bg = this.switchBG[sw] = new ButtonGroup();
            bg.add(buttonOff);
            bg.add(buttonOn);
        }
        for (cond = 0; cond < 11; ++cond) {
            label = this.latchLabel[cond] = new JLabel(latchNames[cond] + ":");
            label.setFont(UiConstants.FONT);
            label = this.latchStatus[cond] = new JLabel("XXX");
            label.setFont(UiConstants.FONT);
            d = label.getPreferredSize();
            d.width = latchStateWidth;
            label.setPreferredSize(d);
            JButton button = this.latchResetBtn[cond] = new JButton("Reset");
            Insets i = button.getMargin();
            i.left -= 3;
            i.right -= 3;
            button.setMargin(i);
            d = button.getPreferredSize();
            d.height -= 9;
            button.setPreferredSize(d);
            button.setFont(UiConstants.FONT);
            button.setFocusable(false);
            button.setName(Integer.toString(cond));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JButton)evt.getSource()).getName();
                    MpmControlPanel.this.clearLatch(Integer.valueOf(name));
                }
            });
        }
        for (cond = 0; cond < 7; ++cond) {
            label = this.conditionLabel[cond] = new JLabel(conditionNames[cond] + ":");
            label.setFont(UiConstants.FONT);
            label = this.conditionStatus[cond] = new JLabel("XXX");
            label.setFont(UiConstants.FONT);
            d = label.getPreferredSize();
            d.width = conditionStateWidth;
            label.setPreferredSize(d);
        }
        TitledBorder border = BorderFactory.createTitledBorder(new LineBorder(Color.BLACK), "PLC States");
        border.setTitleJustification(2);
        border.setTitleFont(UiConstants.FONT);
        border.setTitleColor(UiConstants.BLUE);
        this.plcPanel.setBorder(border);
        this.plcPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbp = new GridBagConstraints();
        gbp.anchor = 18;
        gbp.gridx = 0;
        gbp.gridy = 0;
        gbp.insets.bottom = 4;
        gbp.insets.right = 5;
        int numColm = 3;
        int colm = 0;
        for (int plc = 0; plc < 3; ++plc) {
            if (colm == 0) {
                gbp.gridx = 0;
                ++gbp.gridy;
            }
            gbp.insets.top = plc < numColm ? 4 : 0;
            gbp.insets.left = colm == 0 ? 5 : 35;
            this.plcPanel.add((Component)this.plcLabel[plc], gbp);
            gbp.insets.left = 0;
            ++gbp.gridx;
            this.plcPanel.add((Component)this.plcStatus[plc], gbp);
            ++gbp.gridx;
            colm = (colm + 1) % numColm;
        }
        border = BorderFactory.createTitledBorder(new LineBorder(Color.BLACK), "Switches");
        border.setTitleJustification(2);
        border.setTitleFont(UiConstants.FONT);
        border.setTitleColor(UiConstants.BLUE);
        this.switchPanel.setBorder(border);
        this.switchPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = 18;
        gbs.gridy = 0;
        numColm = 2;
        colm = 0;
        for (int sw = 0; sw < 7; ++sw) {
            if (colm == 0) {
                gbs.gridx = 0;
                ++gbs.gridy;
            }
            gbs.insets.top = sw < numColm ? 4 : 0;
            gbs.insets.left = colm == 0 ? 5 : 40;
            this.switchPanel.add((Component)this.switchLabel[sw], gbs);
            gbs.insets.left = 6;
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchStatus[sw], gbs);
            ++gbs.gridx;
            gbs.insets.left = 8;
            gbs.insets.top -= 4;
            this.switchPanel.add((Component)this.switchOffRB[sw], gbs);
            ++gbs.gridx;
            gbs.insets.left = 3;
            gbs.insets.right = 3;
            this.switchPanel.add((Component)this.switchOnRB[sw], gbs);
            gbs.insets.right = 0;
            ++gbs.gridx;
            colm = (colm + 1) % numColm;
        }
        border = BorderFactory.createTitledBorder(new LineBorder(Color.BLACK), "PLC Error Conditions");
        border.setTitleJustification(2);
        border.setTitleFont(UiConstants.FONT);
        border.setTitleColor(UiConstants.BLUE);
        this.latchPanel.setBorder(border);
        this.latchPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbl = new GridBagConstraints();
        gbl.anchor = 18;
        gbl.gridy = 0;
        numColm = 2;
        colm = 0;
        for (int cond2 = 0; cond2 < 11; ++cond2) {
            if (colm == 0) {
                gbl.gridx = 0;
                ++gbl.gridy;
            }
            gbl.insets.top = cond2 < numColm ? 4 : 0;
            gbl.insets.bottom = 4;
            gbl.insets.left = colm == 0 ? 5 : 40;
            this.latchPanel.add((Component)this.latchLabel[cond2], gbl);
            gbl.insets.left = 5;
            ++gbl.gridx;
            this.latchPanel.add((Component)this.latchStatus[cond2], gbl);
            ++gbl.gridx;
            --gbl.insets.top;
            gbl.insets.right = 4;
            this.latchPanel.add((Component)this.latchResetBtn[cond2], gbl);
            gbl.insets.right = 0;
            ++gbl.gridx;
            colm = (colm + 1) % numColm;
        }
        border = BorderFactory.createTitledBorder(new LineBorder(Color.BLACK), "PLC Running Conditions");
        border.setTitleJustification(2);
        border.setTitleFont(UiConstants.FONT);
        border.setTitleColor(UiConstants.BLUE);
        this.conditionPanel.setBorder(border);
        this.conditionPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.insets.bottom = 4;
        gbc.insets.right = 5;
        numColm = 2;
        colm = 0;
        for (int cond3 = 0; cond3 < 7; ++cond3) {
            if (colm == 0) {
                gbc.gridx = 0;
                ++gbc.gridy;
            }
            gbc.insets.top = cond3 < numColm ? 4 : 0;
            gbc.insets.left = colm == 0 ? 5 : 35;
            this.conditionPanel.add((Component)this.conditionLabel[cond3], gbc);
            gbc.insets.left = 0;
            ++gbc.gridx;
            this.conditionPanel.add((Component)this.conditionStatus[cond3], gbc);
            ++gbc.gridx;
            colm = (colm + 1) % numColm;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(0, 0, 0, 0);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.add((Component)this.systemPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.plcPanel, gbm);
        ++gbm.gridy;
        gbm.insets.top = 6;
        this.add((Component)this.switchPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.latchPanel, gbm);
        ++gbm.gridy;
        gbm.insets.bottom = 6;
        this.add((Component)this.conditionPanel, gbm);
    }

    private void setSwitchOn(int sw, boolean value) {
        this.switchOffRB[sw].setEnabled(false);
        this.switchOnRB[sw].setEnabled(false);
        this.sender.sendCommand(null, "setSwitchOn", new Object[]{sw, value});
    }

    private void clearLatch(int cond) {
        this.latchResetBtn[cond].setEnabled(false);
        this.sender.sendCommand(null, "clearLatch", new Object[]{cond});
    }

    public void updateControlPanel(MpmSysState rs) {
        SwingUtilities.invokeLater(new UpdateSysStatus(rs));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    static {
        MpmControlPanel.plcNames[0] = "Trunk";
        MpmControlPanel.plcNames[1] = "Cold";
        MpmControlPanel.plcNames[2] = "Cryo";
        switchNames = new String[7];
        MpmControlPanel.switchNames[4] = "Block Cold Heater";
        MpmControlPanel.switchNames[3] = "Block Cold Refrig";
        MpmControlPanel.switchNames[6] = "Block Cryo Heater";
        MpmControlPanel.switchNames[5] = "Block Cryo Refrig";
        MpmControlPanel.switchNames[2] = "Block UT Coolant";
        MpmControlPanel.switchNames[1] = "Block REB Power";
        MpmControlPanel.switchNames[0] = "Block UT Power";
        latchNames = new String[11];
        MpmControlPanel.latchNames[5] = "Cold Temp High";
        MpmControlPanel.latchNames[6] = "Cold Temp Low";
        MpmControlPanel.latchNames[7] = "Cryo Temp High";
        MpmControlPanel.latchNames[8] = "Cryo Temp Low";
        MpmControlPanel.latchNames[9] = "Cryo Vacuum Bad";
        MpmControlPanel.latchNames[10] = "Hex Vacuum Bad";
        MpmControlPanel.latchNames[1] = "UT Leak";
        MpmControlPanel.latchNames[2] = "UT Leak Fault";
        MpmControlPanel.latchNames[3] = "UT Smoke";
        MpmControlPanel.latchNames[4] = "UT Smoke Fault";
        MpmControlPanel.latchNames[0] = "UT Temp High";
        conditionNames = new String[7];
        MpmControlPanel.conditionNames[0] = "UT Power Permit";
        MpmControlPanel.conditionNames[1] = "REB Power Permit";
        MpmControlPanel.conditionNames[2] = "UT Coolant Permit";
        MpmControlPanel.conditionNames[3] = "Cold Refrig Permit";
        MpmControlPanel.conditionNames[4] = "Cold Heater Permit";
        MpmControlPanel.conditionNames[5] = "Cryo Refrig Permit";
        MpmControlPanel.conditionNames[6] = "Cryo Heater Permit";
        JLabel label = new JLabel();
        label.setFont(UiConstants.FONT);
        int width = 0;
        for (PLCState pLCState : PLCState.values()) {
            label.setText(pLCState.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        plcStateWidth = width;
        width = 0;
        for (PLCState pLCState : SwitchState.values()) {
            label.setText(pLCState.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        switchStateWidth = width;
        width = 0;
        for (PLCState pLCState : LatchState.values()) {
            label.setText(pLCState.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        latchStateWidth = width;
        width = 0;
        for (PLCState pLCState : ConditionState.values()) {
            label.setText(pLCState.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        conditionStateWidth = width;
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            int cond;
            MpmControlPanel.this.systemPanel.disableSystem();
            for (int plc = 0; plc < 3; ++plc) {
                MpmControlPanel.this.plcStatus[plc].setEnabled(false);
            }
            for (int sw = 0; sw < 7; ++sw) {
                MpmControlPanel.this.switchStatus[sw].setEnabled(false);
                MpmControlPanel.this.switchOffRB[sw].setEnabled(false);
                MpmControlPanel.this.switchOnRB[sw].setEnabled(false);
            }
            for (cond = 0; cond < 11; ++cond) {
                MpmControlPanel.this.latchStatus[cond].setEnabled(false);
                MpmControlPanel.this.latchResetBtn[cond].setEnabled(false);
            }
            for (cond = 0; cond < 7; ++cond) {
                MpmControlPanel.this.conditionStatus[cond].setEnabled(false);
            }
            MpmControlPanel.this.repaint();
        }
    }

    class UpdateSysStatus
    implements Runnable {
        private final MpmSysState vs;

        UpdateSysStatus(MpmSysState vs) {
            this.vs = vs;
        }

        @Override
        public void run() {
            int cond;
            PLCState state;
            MpmControlPanel.this.systemPanel.updateStatus(this.vs.getTickMillis());
            for (int plc = 0; plc < 3; ++plc) {
                state = this.vs.getPlcState(plc);
                MpmControlPanel.this.plcStatus[plc].setText(state.name());
                MpmControlPanel.this.plcStatus[plc].setForeground(state == PLCState.OFFLINE ? UiConstants.BLUE : (state == PLCState.DEAD ? UiConstants.RED : UiConstants.GREEN));
                MpmControlPanel.this.plcStatus[plc].setEnabled(true);
            }
            for (int sw = 0; sw < 7; ++sw) {
                state = this.vs.getSwitchState(sw);
                String text = state.name();
                Color color = state == SwitchState.OFF ? Color.black : (state == SwitchState.ON ? UiConstants.GREEN : UiConstants.BLUE);
                MpmControlPanel.this.switchStatus[sw].setText(text);
                MpmControlPanel.this.switchStatus[sw].setForeground(color);
                JRadioButton selButton = state == SwitchState.ON ? MpmControlPanel.this.switchOnRB[sw] : MpmControlPanel.this.switchOffRB[sw];
                selButton.setSelected(true);
                MpmControlPanel.this.switchStatus[sw].setEnabled(true);
                MpmControlPanel.this.switchOffRB[sw].setEnabled(true);
                MpmControlPanel.this.switchOnRB[sw].setEnabled(true);
            }
            for (cond = 0; cond < 11; ++cond) {
                state = this.vs.getLatch(cond);
                MpmControlPanel.this.latchStatus[cond].setText(state.name());
                MpmControlPanel.this.latchStatus[cond].setForeground(state == LatchState.OFFLINE ? UiConstants.BLUE : (state == LatchState.CLEAR ? UiConstants.GREEN : (state == LatchState.ACTIVE ? UiConstants.RED : UiConstants.PURPLE)));
                MpmControlPanel.this.latchStatus[cond].setEnabled(true);
                MpmControlPanel.this.latchResetBtn[cond].setEnabled(true);
            }
            for (cond = 0; cond < 7; ++cond) {
                state = this.vs.getCondition(cond);
                MpmControlPanel.this.conditionStatus[cond].setText(state.name());
                MpmControlPanel.this.conditionStatus[cond].setForeground(state == ConditionState.OFF ? UiConstants.BLUE : (state == ConditionState.NO ? Color.BLACK : UiConstants.GREEN));
                MpmControlPanel.this.conditionStatus[cond].setEnabled(true);
            }
            MpmControlPanel.this.repaint();
        }
    }
}

