package org.lsst.ccs.subsystem.utility.ui.jas;

import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.base.filter.GenericFilter;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

/**
 * Generic monitoring filter.
 *
 * @author The LSST CCS Team
 */
public class MonitorFilter extends GenericFilter {


    public final static String FIELDS = 
        MonitorField.VALUE.getKey()+","+
        MonitorField.UNITS.getKey()+","+
        MonitorField.LOW_ALARM.getKey()+","+
        MonitorField.LOW_WARN.getKey()+","+
        MonitorField.ALERT_LOW.getKey()+","+
        MonitorField.HIGH_WARN.getKey()+","+
        MonitorField.HIGH_ALARM.getKey()+","+
        MonitorField.ALERT_HIGH.getKey()+","+
        MonitorField.NAME.getKey()+","+
        MonitorField.DESCR.getKey();
    
    public MonitorFilter(String agents) {
        super("MyName", agents, "/main/", "", true, FIELDS);
    }

    
    
    @Override
    public String getDisplayPath(AgentChannel channel) {
        String path = channel.getLocalPath();
        String section = channel.get(AgentChannel.Key.SECTION);
        if ( null == section || section.isEmpty() ) {
            section = "Common";
        }
        int i1 = path.lastIndexOf("/");
        int i2 = path.indexOf(".", i1+1);
        String newPath = "";
        if (i1 != -1 && i2 != -1) {
            newPath = path.substring(i1 + 1, i2)+"//"+section+"//"+ path.substring(i2 + 1);
        } else {
            if ( i1 != -1 ) {
                newPath = section+"//"+path.substring(i1+1);
            } else if (i2 != -1) {
                newPath = section+"//"+path.substring(i2+1);                
            } else {
                newPath = section+"//"+path;
            }
        }        
        return newPath;
    }

}
