package org.lsst.ccs.subsystem.utility.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.utility.constants.UtilityAgentProperties;
import org.lsst.ccs.subsystem.utility.data.UtilityState;
import org.lsst.ccs.subsystem.utility.ui.UTMonitorPanel;

/**
 * @author tonyj
 */
@Plugin(name = "AuxTest Control Plugin", description = "AuxTest Control Plugin")
public class AuxTestControlPlugin extends ConsolePlugin {

    @Override
    public void initialize() {
        OptionalPage optPage = new UTOptionalPage(UtilityAgentProperties.AUXTEST_TYPE, AuxTestControl.class);
        Console.getConsole().getOptionalPageService().add(optPage);
    }
    
    static class AuxTestControl implements Control, StatusMessageListener {

        private CommandSender cmdSender;
        private UTMonitorPanel ctrlPanel;
        
        @Override
        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals(UtilityState.KEY)) {
                    updateControlPanel(((KeyValueData)sd.getSubsystemData()).getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException x) {
            }
        }

        @Override
        public JPanel getControlPanel(CommandSender sndr) {
            cmdSender = sndr;
            return ctrlPanel = new UTMonitorPanel(sndr);
        }

        @Override
        public void initControlPanel() {
            updateControlPanel(cmdSender.sendCommand(null, "getSystemState"));
        }

        @Override
        public void updateControlPanel(Object obj) {
            ctrlPanel.updateControlPanel((UtilityState)obj);
        }

        @Override
        public void disableSystem() {
            ctrlPanel.disableSystem();
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
    
}
