/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.utilities.logging.Logger;

public final class HTMLTextPane
extends JTextPane
implements HasPopupItems {
    private static final int MAX_LENGTH = 10000;
    private final HTMLEditorKit kit;
    private final HTMLDocument doc;
    private final Action clearAction;
    private final Logger log = Logger.getLogger((String)"org.lsst.ccs.plugin.jas3.dictionary");

    public HTMLTextPane() {
        this.setEditable(false);
        try {
            ((DefaultCaret)this.getCaret()).setUpdatePolicy(2);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.kit = new HTMLEditorKit();
        this.doc = new HTMLDocument();
        this.setEditorKit(this.kit);
        Font font = new Font("Monospaced", 0, 15);
        String bodyrule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt;}";
        this.doc.getStyleSheet().addRule(bodyrule);
        this.setDocument(this.doc);
        this.clearAction = new AbstractAction("Clear"){

            @Override
            public void actionPerformed(ActionEvent e) {
                HTMLTextPane.this.setText("");
            }
        };
    }

    public void insertHTML(String s) {
        try {
            this.kit.insertHTML(this.doc, this.doc.getLength(), s, 0, 0, null);
            int overLength = this.doc.getLength() - 10000;
            if (overLength > 0) {
                this.removeOverLength(overLength);
            }
        }
        catch (BadLocationException ex) {
            this.log.error((Object)ex);
        }
        catch (IOException ex) {
            this.log.error((Object)ex);
        }
    }

    private void removeOverLength(int overLength) throws BadLocationException {
        this.doc.remove(0, overLength);
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component cmpnt, Point point) {
        menu.add(new JMenuItem(this.clearAction));
        return menu;
    }
}

