/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.messaging.LockLevelService;
import org.lsst.ccs.services.AgentLockServiceDelegate;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.LocalAgentLockService;
import org.lsst.ccs.services.RemoteAgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;
import org.lsst.ccs.utilities.logging.Logger;

public class AgentLockService
implements LockLevelService,
ServiceLifecycle,
AgentService {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.services.lockservice");
    AgentLockServiceDelegate delegate;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;

    public Agent getAgent() {
        return this.agent;
    }

    public AgentStateService getAgentStateService() {
        return this.agentStateService;
    }

    @Override
    public String getAgentServiceName() {
        return "lockService";
    }

    @Override
    public void preInit() {
        String p;
        switch (p = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.lockservice", "local")) {
            case "remote": {
                this.delegate = new RemoteAgentLockService(this);
                break;
            }
            case "local": {
                this.delegate = new LocalAgentLockService(this);
                break;
            }
            default: {
                throw new RuntimeException("Invalid org.lsst.ccs.lockservice value " + p);
            }
        }
        this.delegate.preInit();
    }

    @Override
    public void preStart() {
        this.delegate.preStart();
    }

    public void setLevelForAgent(String agentName, int level) throws UnauthorizedLevelException, UnauthorizedLockException, IOException {
        this.delegate.setLevelForAgent(agentName, level);
    }

    public int getLevelForAgent(String agentName) {
        return this.delegate.getLevelForAgent(agentName);
    }

    public AgentLock getLockForAgent(String agentName) {
        return this.delegate.getLockForAgent(agentName);
    }

    public void lockAgent(String agentName) throws UnauthorizedLockException, IOException {
        this.delegate.lockAgent(agentName);
    }

    public void unlockAgent(String agentName) throws IOException {
        this.delegate.unlockAgent(agentName);
    }

    public Map<String, AgentLock> getLocks() {
        return this.delegate.getLocks();
    }

    public Map<String, AgentLock> getHeldLocks() {
        return this.delegate.getHeldLocks();
    }

    public boolean validateLock(AgentLock lock) {
        return this.delegate.validateLock(lock);
    }

    public void addAgentLevelListener(AgentLevelListener l) {
        this.delegate.addAgentLevelListener(l);
    }

    public void removeAgentLevelListener(AgentLevelListener l) {
        this.delegate.removeAgentLevelListener(l);
    }

    public void addAgentLockUpdateListener(AgentLockUpdateListener slul) {
        this.delegate.addAgentLockUpdateListener(slul);
    }

    public void removeAgentLockUpdateListener(AgentLockUpdateListener l) {
        this.delegate.removeAgentLockUpdateListener(l);
    }

    public List<String> getLockableAgents() {
        return this.delegate.getLockableAgents();
    }

    public List<String> getLockedAgents() {
        return this.delegate.getLockedAgents();
    }

    public List<String> getAllWorkerAgents() {
        return this.delegate.getAllWorkerAgents();
    }

    public static interface AgentLockUpdateListener {
        public void onAgentLockUpdate(String var1, AgentLock var2);
    }

    public static interface AgentLevelListener {
        public void onAgentLevelChange(String var1, int var2);
    }
}

