/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.utility.data.MpmSysState;
import org.lsst.ccs.subsystem.utility.ui.MpmControlPanel;
import org.lsst.ccs.subsystem.utility.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.utility.ui.jas.Control;
import org.lsst.ccs.subsystem.utility.ui.jas.UTOptionalPage;

@Plugin(name="Protection Control Plugin", description="Protection Control Plugin")
public class MpmControlPlugin
extends ConsolePlugin {
    public void initialize() {
        UTOptionalPage optPage = new UTOptionalPage("mpmType", ProtControl.class);
        Console.getConsole().getOptionalPageService().add((OptionalPage)optPage);
    }

    static class ProtControl
    implements Control,
    StatusMessageListener {
        private CommandSender cmdSender;
        private MpmControlPanel ctrlPanel;

        ProtControl() {
        }

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("MPMState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        @Override
        public JPanel getControlPanel(CommandSender sndr) {
            this.cmdSender = sndr;
            this.ctrlPanel = new MpmControlPanel(sndr);
            return this.ctrlPanel;
        }

        @Override
        public void initControlPanel() {
            this.updateControlPanel(this.cmdSender.sendCommand(null, "getSystemState", new Object[0]));
        }

        @Override
        public void updateControlPanel(Object obj) {
            this.ctrlPanel.updateControlPanel((MpmSysState)obj);
        }

        @Override
        public void disableSystem() {
            this.ctrlPanel.disableSystem();
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
}

