/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.lsst.ccs.subsystem.utility.ui.UiConstants;
import org.lsst.ccs.subsystem.utility.ui.jas.CommandSender;

public class SystemStatusPanel
extends JPanel {
    private final CommandSender sender;
    private double mainPeriod = 5.0;
    private final JLabel stateLabel = new JLabel("System State:  ");
    private final JLabel stateStatus = new JLabel("STOPPED");
    private final JPanel periodPanel = new JPanel();
    private final JLabel periodLabel = new JLabel("Update Period: ");
    private final JTextField periodTextField = new JTextField();
    private final JLabel periodUnitsLabel = new JLabel("sec");
    private static final long serialVersionUID = 1L;

    public SystemStatusPanel(CommandSender cons) {
        this.sender = cons;
        this.initComponents();
        this.disableSystem();
    }

    public void updateStatus(int tickMillis) {
        this.stateStatus.setText("RUNNING");
        this.stateStatus.setForeground(UiConstants.GREEN);
        this.periodTextField.setEnabled(true);
        this.mainPeriod = (double)tickMillis / 1000.0;
        this.periodTextField.setText(String.valueOf(this.mainPeriod));
    }

    public void disableSystem() {
        this.stateStatus.setText("STOPPED");
        this.stateStatus.setForeground(UiConstants.RED);
        this.periodTextField.setEnabled(false);
    }

    private void initComponents() {
        this.stateLabel.setFont(UiConstants.FONT);
        this.stateStatus.setFont(UiConstants.FONT);
        Dimension d = this.stateStatus.getPreferredSize();
        d.width = 150;
        this.stateStatus.setMinimumSize(d);
        this.stateStatus.setPreferredSize(d);
        this.periodLabel.setFont(UiConstants.FONT);
        d = this.periodTextField.getPreferredSize();
        d.width = 45;
        this.periodTextField.setMinimumSize(d);
        this.periodTextField.setPreferredSize(d);
        this.periodTextField.setHorizontalAlignment(0);
        this.periodTextField.setText("...");
        this.periodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemStatusPanel.this.setUpdatePeriod();
            }
        });
        this.periodUnitsLabel.setFont(UiConstants.FONT);
        this.periodPanel.add(this.periodTextField);
        this.periodPanel.add(this.periodUnitsLabel);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbh = new GridBagConstraints();
        gbh.insets = new Insets(5, 0, 0, 0);
        gbh.gridx = 0;
        gbh.gridy = 0;
        gbh.anchor = 13;
        this.add((Component)this.stateLabel, gbh);
        ++gbh.gridx;
        gbh.anchor = 17;
        this.add((Component)this.stateStatus, gbh);
        ++gbh.gridx;
        gbh.gridwidth = 2;
        gbh.anchor = 13;
        this.add((Component)this.periodLabel, gbh);
        gbh.gridx += 2;
        gbh.gridwidth = 1;
        gbh.anchor = 17;
        this.add((Component)this.periodPanel, gbh);
        gbh.gridx = 0;
    }

    private void setUpdatePeriod() {
        try {
            double value = Double.valueOf(this.periodTextField.getText());
            this.sender.sendCommand(null, "setUpdatePeriod", (int)(1000.0 * value));
            this.periodTextField.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.periodTextField.setText(String.valueOf(this.mainPeriod));
        }
    }
}

