/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Set;
import org.lsst.ccs.config.FileWriterProvider;
import org.lsst.ccs.config.InMemoryWriterProvider;
import org.lsst.ccs.config.WriterProvider;

class InMemoryFileWriterProvider
extends WriterProvider {
    private final WriterProvider inMemoryWriterProvider = new InMemoryWriterProvider();
    private final WriterProvider fileWriterProvider = new FileWriterProvider();

    InMemoryFileWriterProvider() {
    }

    @Override
    public PrintWriter getPrintWriter(String fileName) throws IOException {
        return this.inMemoryWriterProvider.getPrintWriter(fileName);
    }

    @Override
    public Properties getProperties(String fileName) throws IOException {
        Properties props = this.inMemoryWriterProvider.getProperties(fileName);
        if (props == null) {
            Properties fileProps = this.fileWriterProvider.getProperties(fileName);
            if (fileProps == null) {
                return null;
            }
            PrintWriter printW = this.getPrintWriter(fileName);
            String comments = "Properties loaded from file " + fileName;
            fileProps.store(printW, comments);
            props = fileProps;
        }
        return props;
    }

    @Override
    public Set<String> findMatchingPropertiesFiles(String pattern) {
        return this.inMemoryWriterProvider.findMatchingPropertiesFiles(pattern);
    }

    @Override
    public String locateFile(String fileName) {
        return this.inMemoryWriterProvider.locateFile(fileName);
    }
}

