/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class KeyValueData
implements Serializable {
    private static final long serialVersionUID = -45918237359438L;
    private final String key;
    private final Serializable value;
    private final CCSTimeStamp ccsTimeStamp;
    private final KeyValueDataType type;

    public KeyValueData(String key, Serializable value, CCSTimeStamp ccsTimeStamp, KeyValueDataType type) {
        this.key = key;
        this.value = value;
        this.type = type;
        this.ccsTimeStamp = ccsTimeStamp;
    }

    public KeyValueData(String key, Serializable value, CCSTimeStamp ccsTimeStamp) {
        this(key, value, ccsTimeStamp, KeyValueDataType.KeyValueTrendingData);
    }

    public KeyValueData(String key, Serializable value) {
        this(key, value, CCSTimeStamp.currentTime());
    }

    public CCSTimeStamp getCCSTimeStamp() {
        return this.ccsTimeStamp;
    }

    public Serializable getValue() {
        return this.value;
    }

    public String getKey() {
        return this.key;
    }

    public KeyValueDataType getType() {
        return this.type;
    }

    public String toString() {
        return "KeyValueData{ key=" + this.key + ", value=" + this.value + ", timestamp=" + this.ccsTimeStamp + ", type=" + (Object)((Object)this.type) + " }";
    }

    public static enum KeyValueDataType {
        KeyValueTrendingData,
        KeyValuePlotData,
        KeyValueMetaData;

    }
}

