/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.persist;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.ConsoleService;
import org.lsst.ccs.gconsole.services.persist.CreationDialog;
import org.lsst.ccs.gconsole.services.persist.Creator;
import org.lsst.ccs.gconsole.services.persist.CreatorDescriptor;
import org.lsst.ccs.gconsole.services.persist.CreatorExecutable;
import org.lsst.ccs.gconsole.services.persist.Persistable;

@Plugin(name="Persistence Service Plugin", id="persistence-service", description="Service that facilitates persisting data between the graphical console sessions.")
public class PersistenceService
extends ConsolePlugin
implements ConsoleService {
    private final ArrayList<Creator> factories = new ArrayList();

    @Override
    public void startService() {
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            Enumeration<URL> e = loader.getResources("gui/factories.txt");
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                try {
                    InputStream ins = url.openStream();
                    Throwable throwable = null;
                    try {
                        BufferedReader in = new BufferedReader(new InputStreamReader(ins));
                        Throwable throwable2 = null;
                        try {
                            String line;
                            while ((line = in.readLine()) != null) {
                                try {
                                    Create an;
                                    int mod;
                                    Class<?> clazz = Class.forName(line.trim());
                                    for (Method method : clazz.getDeclaredMethods()) {
                                        mod = method.getModifiers();
                                        if (!Modifier.isPublic(mod) || !Modifier.isStatic(mod) || (an = method.getAnnotation(Create.class)) == null) continue;
                                        this.factories.add(new CreatorExecutable(method, null));
                                    }
                                    for (Executable executable : clazz.getConstructors()) {
                                        mod = ((Constructor)executable).getModifiers();
                                        if (!Modifier.isPublic(mod) || (an = ((Constructor)executable).getAnnotation(Create.class)) == null) continue;
                                        this.factories.add(new CreatorExecutable(executable, null));
                                    }
                                }
                                catch (ClassNotFoundException | SecurityException exception) {
                                }
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (in == null) continue;
                            if (throwable2 != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            in.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (ins == null) continue;
                        if (throwable != null) {
                            try {
                                ins.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        ins.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("Factories found: " + this.factories.size());
    }

    public Persistable make(Persistable.Descriptor descriptor) {
        Creator.Descriptor desc = descriptor.getCreator();
        if (desc == null) {
            return null;
        }
        Creator factory = this.getFactory(desc.getCategory(), desc.getPath());
        if (factory == null) {
            return null;
        }
        Persistable out = null;
        try {
            out = factory.make(desc.getParameters());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (out == null) {
            return null;
        }
        Persistable.Descriptor d = out.getDescriptor();
        d.setCategory(descriptor.getCategory());
        d.setPath(descriptor.getPath());
        d.setName(descriptor.getName());
        d.setDescription(descriptor.getDescription());
        out.restore(descriptor);
        return out;
    }

    public Persistable make(Persistable.Descriptor descriptor, String title, JComponent parent, String category) {
        ArrayList<Creator> ff = this.getSaved(category);
        ff.addAll(this.getFactories(category));
        return CreationDialog.show(descriptor, title, (Component)parent, ff);
    }

    public void save(Persistable.Descriptor descriptor) {
        throw new UnsupportedOperationException();
    }

    public void saveAs(Persistable.Descriptor descriptor, JComponent parent) {
        throw new UnsupportedOperationException();
    }

    public Creator getFactory(String category, String path) {
        for (Creator f : this.factories) {
            if (!path.equals(f.getPath()) || category != null && !category.equals(f.getCategory())) continue;
            return f;
        }
        return null;
    }

    public List<Creator> getFactories(String category) {
        if (category == null) {
            return new ArrayList<Creator>(this.factories);
        }
        return this.factories.stream().filter(f -> category.equals(f.getCategory())).collect(Collectors.toList());
    }

    public List<Persistable.Descriptor> getSavedDescriptors(String category) {
        return Collections.emptyList();
    }

    public ArrayList<Creator> getSaved(String category) {
        List<Persistable.Descriptor> dd = this.getSavedDescriptors(category);
        ArrayList<Creator> out = new ArrayList<Creator>(dd.size());
        for (Persistable.Descriptor d : dd) {
            out.add(new CreatorDescriptor(d));
        }
        return out;
    }
}

