package org.lsst.ccs.subsystem.utility.ui.jas;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.subsystem.utility.ui.UTMonitorGui;

/**
 *
 * @author tonyj
 */
@org.lsst.ccs.gconsole.annotations.Plugin(name="Utility Monitor Plugin", description="Utility Monitor Plugin")
public class UTMonitorPlugin extends ConsolePlugin {

    private volatile UTMonitorGui gui;
    private volatile PanelManager pm;

    @Override
    public void initialize() {
        
        pm = getConsole().getPanelManager();
        Action openUtilityGui = new AbstractAction("Utility") {
            @Override
            public void actionPerformed(ActionEvent e) {
                if ( gui == null ) {
                    gui = new UTMonitorGui("ccs-auxtest");
                    gui.initGui();
                    pm.open(gui.getGuiLayout(), "Utility Test");
                } else {                    
                    closeMonitorGUI();
                }
            }
        };
        
        pm.addListener(e -> {
            if (e.hasKey(Panel.OPEN) && (Boolean) e.getNewValue() == false) {
                if ( gui != null && e.getSource().equals(gui.getGuiLayout()) ) {
                    closeMonitorGUI();
                    openUtilityGui.putValue(Action.SELECTED_KEY, false);
                }
            }
        });
        
        openUtilityGui.putValue(Action.SELECTED_KEY, false);
        getServices().addMenu(openUtilityGui, "CCS Subsystems");
        
    }
    
    private void closeMonitorGUI() {
        pm.close(gui.getGuiLayout());
        gui = null;
    }
    
}
