package org.lsst.ccs.subsystem.utility.ui;

import java.awt.BorderLayout;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystem.monitor.ui.MonitorAssembly;
import org.lsst.ccs.subsystem.monitor.ui.MonitorGui;
import org.lsst.ccs.subsystem.utility.data.UtilityFullState;
import org.lsst.ccs.subsystem.utility.data.UtilityState;

/**
 *  Implements the utility control panel / monitor panel assembly.
 *
 *  @author Owen Saxton
 */
public class UTMonitorAssembly extends MonitorGui.Panel {

    MonitorAssembly mon;
    UTMonitorPanel panel;
    
    public UTMonitorAssembly(UTMonitorGui gui) {
        setLayout(new java.awt.BorderLayout());
        mon = new MonitorAssembly(gui);
        add(mon, BorderLayout.CENTER);
        panel = new UTMonitorPanel(gui);
        add(panel, BorderLayout.SOUTH);
    }

    public void setSubsystem(String name) {
        mon.setSubsystems(name);
        panel.setSubsystem(name);
    }

    @Override
    public void disableSystem(String name, int id) {
        panel.disableSystem(id);
        mon.disableSystem(name);
    }

    @Override
    public void updatePanel(String name, int id, Object d) {
        if (d instanceof UtilityFullState) {
            UtilityFullState r = (UtilityFullState)d;
            mon.updateTableModel(name, r.getMonitorFullState());
            panel.updateControlPanel(id, r.getUtilityState());
        }
    }

    @Override
    public void handleStatusData(String name, int id, long time, String key,
                                 Object d) {
        if (key.equals(UtilityState.KEY)) {
            panel.updateControlPanel(id, (UtilityState)((KeyValueData)d).getValue());
        }
        else {
            mon.handleData(name, key, d);
        }
    }

    private static final long serialVersionUID = 1L;
}
