/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.localdb.configdb.model.Configuration;
import org.lsst.ccs.localdb.configdb.model.ConfigurationInfoData;
import org.lsst.ccs.localdb.configdb.model.ConfigurationParameter;
import org.lsst.ccs.localdb.configdb.model.ConfigurationParameterValue;
import org.lsst.ccs.localdb.configdb.model.ConfigurationRun;
import org.lsst.ccs.localdb.configdb.model.ConfigurationUtils;
import org.lsst.ccs.localdb.configdb.model.Description;
import org.lsst.ccs.localdb.configdb.model.GlobalConfiguration;
import org.lsst.ccs.localdb.configdb.model.PackCst;
import org.lsst.ccs.localdb.configdb.model.ParameterPath;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;
import org.lsst.ccs.utilities.logging.Logger;

public class HibernateDAO {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb.configdb");
    private final SessionFactory sessionFactory;
    private Transaction currentTransaction;
    private final ThreadLocal<Session> session;

    public HibernateDAO(SessionFactory fac) {
        this.sessionFactory = fac;
        this.session = new ThreadLocal<Session>(){

            @Override
            public Session initialValue() {
                return HibernateDAO.this.sessionFactory.openSession();
            }
        };
    }

    public void begin() {
        log.debug((Object)"begin transaction");
        this.currentTransaction = this.getSession().beginTransaction();
    }

    public void end() throws Exception {
        log.debug((Object)"end transaction");
        try {
            this.currentTransaction.commit();
        }
        catch (Exception ex) {
            log.error((Object)("caught exception when persisting : " + ex), (Throwable)ex);
            try {
                if (this.currentTransaction != null && (this.currentTransaction.getStatus() == TransactionStatus.ACTIVE || this.currentTransaction.getStatus() == TransactionStatus.MARKED_ROLLBACK)) {
                    this.currentTransaction.rollback();
                }
            }
            catch (Exception rbEx) {
                log.error((Object)("Rollback of transaction failed : " + rbEx), (Throwable)rbEx);
                throw rbEx;
            }
            throw ex;
        }
        finally {
            if (this.getSession().isOpen()) {
                this.getSession().close();
            }
            this.currentTransaction = null;
            this.session.remove();
        }
    }

    public void close() {
        this.getSession().close();
        this.sessionFactory.close();
    }

    public void persist(Object obj) {
        this.getSession().persist(obj);
    }

    private Session getSession() {
        return this.session.get();
    }

    public Description getDescription(long id) {
        return (Description)this.getSession().get(Description.class, (Serializable)Long.valueOf(id));
    }

    public Configuration getConfigurationOrNull(Description desc, String name, String cat, int version) {
        if (version < 0) {
            return null;
        }
        return (Configuration)this.getSession().createQuery("from Configuration where description=:description and configName =:tag and category=:cat and version =:version").setEntity("description", (Object)desc).setString("tag", name).setString("cat", cat).setInteger("version", version).uniqueResult();
    }

    private Configuration getConfigurationOrNull(Description desc, String name, String cat, Long checkSum) {
        Configuration res = (Configuration)this.getSession().createQuery("from Configuration where description=:description and configName =:tag and category=:cat and checkSum =:checkSum").setEntity("description", (Object)desc).setString("tag", name).setString("cat", cat).setLong("checkSum", checkSum.longValue()).uniqueResult();
        if (res != null) {
            log.fine((Object)("found matching configuration " + res.getConfigurationDescriptionString()));
        }
        return res;
    }

    public Configuration getConfigurationOrCreate(Description desc, String name, String cat, int version, List<ConfigurationParameterInfo> cpis, long date, ConfigurationRun previousRun) {
        Configuration res;
        block9: {
            res = null;
            if (version != -3 && (res = this.getConfigurationOrNull(desc, name, cat, version)) == null) {
                log.warn((Object)"a versioned configuration was not found : creating a new one");
            }
            Long cs = null;
            if (res == null) {
                try {
                    cs = ConfigurationUtils.computeCheckSum(desc.getId(), cpis);
                    res = this.getConfigurationOrNull(desc, name, cat, cs);
                }
                catch (Exception ex) {
                    log.error((Object)"cannot compute configuration checksum", (Throwable)ex);
                    return null;
                }
            }
            if (res != null) break block9;
            res = this.createNextConfiguration(desc, name, cat, date, cs);
            if (previousRun == null) {
                for (ConfigurationParameterInfo cpi : cpis) {
                    ConfigurationParameter cp = desc.getConfigurationParameters().get(ParameterPath.valueOf(cpi.getPathName()));
                    res.addConfigurationParameterValue(new ConfigurationParameterValue(cp, cpi.getConfiguredValue(), date));
                }
            } else {
                for (ConfigurationParameterInfo cpi : cpis) {
                    ParameterPath path = ParameterPath.valueOf(cpi.getPathName());
                    ConfigurationParameter cp = desc.getConfigurationParameters().get(path);
                    ConfigurationParameterValue previousValue = previousRun.getConfigurationParameterValueForRun(path);
                    if (cpi.getConfiguredValue().equals(previousValue.getValue())) {
                        res.addConfigurationParameterValue(previousValue);
                        continue;
                    }
                    log.warn((Object)("parameter : " + cp.getParameterPath() + " had the following value in the previous run : " + previousValue.getValue() + " but is now : " + cpi.getCurrentValue()));
                    res.addConfigurationParameterValue(new ConfigurationParameterValue(previousValue.getConfigurationParameter(), cpi.getConfiguredValue(), date));
                }
            }
        }
        return res;
    }

    public ConfigurationRun populateRunFromScratch(ConfigurationRun run, List<ConfigurationParameterInfo> changes) {
        for (ConfigurationParameterInfo cpi : changes) {
            ConfigurationParameterValue dirtyVal = this.createConfigurationParameterValue(run.getConfiguration().getDescription(), cpi.getPathName(), cpi.getCurrentValue(), run.getTstart());
            run.addRuntimeChange(dirtyVal);
        }
        return this.persistNextConfigurationRun(run, null);
    }

    public ConfigurationRun populateRunFromPreviousRun(ConfigurationRun previousRun, ConfigurationRun newRun, List<ConfigurationParameterInfo> changes) {
        Configuration prevConfig = previousRun.getConfiguration();
        Configuration newConfig = newRun.getConfiguration();
        if (changes.isEmpty()) {
            GlobalConfiguration newGC = newRun.getGlobalConfiguration();
            GlobalConfiguration prevGC = previousRun.getGlobalConfiguration();
            if ((newGC != null && prevGC != null && newGC.getId() == previousRun.getId() || newGC == null && prevGC == null) && !previousRun.isDirty() && prevConfig.getConfigName().equals(newConfig.getConfigName()) && prevConfig.getVersion() == newConfig.getVersion()) {
                return previousRun;
            }
            return this.persistNextConfigurationRun(newRun, previousRun);
        }
        if (!prevConfig.getConfigName().equals(newConfig.getConfigName())) {
            log.warning((Object)"inconsistency detected");
            previousRun.setTstop(newRun.getTstart());
            return this.populateRunFromScratch(newRun, changes);
        }
        ArrayList<ConfigurationParameterValue> delta = new ArrayList<ConfigurationParameterValue>();
        for (ConfigurationParameterInfo cpi : changes) {
            ParameterPath path = ParameterPath.valueOf(cpi.getPathName());
            String currentValue = cpi.getCurrentValue();
            ConfigurationParameterValue previousChange = previousRun.getRuntimeChanges().get(path);
            if (previousChange != null && previousChange.getValue().equals(currentValue)) continue;
            ConfigurationParameterValue cpv = new ConfigurationParameterValue(newRun.getConfiguration().getDescription().getConfigurationParameters().get(path), currentValue, newRun.getTstart());
            delta.add(cpv);
        }
        if (delta.isEmpty()) {
            return previousRun;
        }
        for (ConfigurationParameterValue cpv : delta) {
            newRun.addRuntimeChange(cpv);
        }
        return this.persistNextConfigurationRun(newRun, previousRun);
    }

    private Configuration createNextConfiguration(Description desc, String name, String cat, long date, Long cs) {
        Configuration latestConfiguration = this.getLatestConfiguration(desc, cat, name);
        int latestVersion = -1;
        if (latestConfiguration != null) {
            latestVersion = latestConfiguration.getVersion();
            latestConfiguration.setLatestVersion(false);
            this.getSession().persist((Object)latestConfiguration);
        }
        Configuration res = new Configuration(desc, cat, name, date, latestVersion + 1);
        res.setCheckSum(cs);
        this.getSession().persist((Object)res);
        return res;
    }

    private ConfigurationRun persistNextConfigurationRun(ConfigurationRun nextRun, ConfigurationRun previousRun) {
        if (previousRun != null) {
            previousRun.setTstop(nextRun.getTstart());
        }
        this.getSession().persist((Object)nextRun);
        return nextRun;
    }

    private Configuration getLatestConfiguration(Description desc, String cat, String name) {
        Configuration latestConfiguration = (Configuration)this.getSession().createQuery("from Configuration c where c.description=:desc and c.configName=:name and c.category=:cat and c.version=(select max(co.version) from Configuration co where co.description=:desc and co.configName=:name and co.category=:cat)").setEntity("desc", (Object)desc).setString("name", name).setString("cat", cat).uniqueResult();
        if (latestConfiguration == null) {
            log.debug((Object)("no configuration for " + cat + ":" + name + " for description " + desc.getId()));
        }
        return latestConfiguration;
    }

    private ConfigurationParameterValue createConfigurationParameterValue(Description desc, String path, String value, long time) {
        ConfigurationParameterValue cpv = new ConfigurationParameterValue(desc.fetch(path), value, time);
        this.getSession().persist((Object)cpv);
        return cpv;
    }

    public void cleanupConfigurationRuns(Description desc, long time) {
        Map<String, ConfigurationRun> activeRuns = this.getActiveConfigurationRuns(desc);
        for (ConfigurationRun cr : activeRuns.values()) {
            log.info((Object)("suspicious run found for " + desc.getAgentDesc().getAgentName() + ", starting at " + cr.getTstart() + " with no end date."));
            cr.setTstop(time);
            this.getSession().persist((Object)cr);
        }
    }

    public Configuration getLatestRunningConfiguration(Description desc, String category) {
        return this.getConfigRunningAt(desc, category, PackCst.STILL_VALID);
    }

    public Configuration getConfigRunningAt(Description desc, String category, long date) {
        ConfigurationRun run = this.getConfigurationRunAt(desc, category, date);
        if (run == null) {
            return null;
        }
        return run.getConfiguration();
    }

    public String getActiveValueAt(Description desc, String category, String parameterPath, long date) {
        ConfigurationRun run = this.getConfigurationRunAt(desc, category, date);
        if (run == null) {
            return null;
        }
        return run.getConfigurationParameterValueForRun(ParameterPath.valueOf(parameterPath)).getValue();
    }

    public void endRun(Description description, long endTime) {
        Map<String, ConfigurationRun> currentRuns = this.getActiveConfigurationRuns(description);
        for (ConfigurationRun cr : currentRuns.values()) {
            cr.setTstop(endTime);
            this.getSession().update((Object)cr);
        }
    }

    private ConfigurationParameter getConfigurationParameter(String agentName, ConfigurationParameterInfo cpi) {
        ConfigurationParameter cp = (ConfigurationParameter)this.getSession().createQuery("from ConfigurationParameter where agentName=:agentName and componentName=:componentName and parameterName=:parameterName and typeName=:typeName and category=:category").setString("agentName", agentName).setString("componentName", cpi.getComponentName()).setString("parameterName", cpi.getParameterName()).setString("typeName", cpi.getType()).setString("category", cpi.getCategoryName()).uniqueResult();
        if (cp == null) {
            log.fine((Object)("creating a new configuration parameter entity for " + agentName + " : " + cpi.getComponentName() + "/" + cpi.getParameterName()));
            cp = new ConfigurationParameter(agentName, new ParameterPath(cpi.getComponentName(), cpi.getParameterName()), cpi.getType(), cpi.getDescription(), "", cpi.getCategoryName(), 0);
            this.getSession().persist((Object)cp);
        }
        return cp;
    }

    public Description findDescriptionOrCreate(AgentDesc ad, List<ConfigurationParameterInfo> cpis) {
        this.getSession().update((Object)ad);
        Description desc = this.findDescriptionOrNull(ad.getAgentName(), cpis);
        if (desc == null) {
            log.fine((Object)("no matching description found for " + ad.getAgentName() + " : creating a new one"));
            desc = new Description(ad);
            HashMap<ParameterPath, ConfigurationParameter> cpMap = new HashMap<ParameterPath, ConfigurationParameter>();
            for (ConfigurationParameterInfo cpi : cpis) {
                ConfigurationParameter cp = this.getConfigurationParameter(ad.getAgentName(), cpi);
                cpMap.put(cp.getParameterPath(), cp);
            }
            desc.setConfigurationParameters(cpMap);
            this.getSession().persist((Object)desc);
        }
        return desc;
    }

    public Description findDescriptionOrNull(String agentName, List<ConfigurationParameterInfo> cpis) {
        List cpisNonFinal = cpis.stream().filter(cp -> !cp.isFinal()).collect(Collectors.toList());
        List list = this.getSession().createQuery("from Description where agentName=:agentName").setString("agentName", agentName).list();
        for (Description desc : list) {
            Map<ParameterPath, ConfigurationParameter> map = desc.getConfigurationParameters();
            if (map.size() != cpis.size()) continue;
            boolean matching = true;
            for (ConfigurationParameterInfo cpi : cpisNonFinal) {
                ConfigurationParameter cp2 = map.get(ParameterPath.valueOf(cpi.getPathName()));
                if (cp2 != null && cp2.getCategory().equals(cpi.getCategoryName()) && cp2.getTypeName().equals(cpi.getType())) continue;
                matching = false;
                break;
            }
            if (!matching) continue;
            log.fine((Object)("found matching description for " + agentName + " : " + desc.getId()));
            return desc;
        }
        return null;
    }

    public ConfigurationRun getActiveConfigurationRun(Description desc, String category) {
        ConfigurationRun cr = (ConfigurationRun)this.getSession().createQuery("from ConfigurationRun where configuration.description=:desc and configuration.category=:cat and tstop=:tstop").setEntity("desc", (Object)desc).setLong("tstop", PackCst.STILL_VALID).setString("cat", category).uniqueResult();
        return cr;
    }

    public ConfigurationInfoData getConfigurationInfoData(Description desc, long date) {
        ConfigurationInfoData res = (ConfigurationInfoData)this.getSession().createQuery("from ConfigurationInfoData cid where cid.description=:desc and cid.time <=:date order by cid.time desc").setEntity("desc", (Object)desc).setLong("date", date).setMaxResults(1).uniqueResult();
        if (res == null) {
            log.info((Object)("no ConfigurationInfoData found for date " + date));
        }
        return res;
    }

    public ConfigurationRun getConfigurationRunAt(Description desc, String category, long date) {
        ConfigurationInfoData cid = this.getConfigurationInfoData(desc, date);
        ConfigurationRun run = null;
        if (cid != null && (run = cid.getConfigurationRuns().get(category)).getTstop() <= date) {
            log.warn((Object)("for date : " + date + ", CID was found but its run ends at " + run.getTstop()));
            run = null;
        }
        if (run == null) {
            log.warning((Object)("no configuration run at " + date + " for subsystem " + desc.getAgentDesc().getAgentName() + " and category " + category));
        }
        return run;
    }

    public Map<String, ConfigurationRun> getActiveConfigurationRuns(Description desc) {
        List list = this.getSession().createQuery("from ConfigurationRun where configuration.description=:description and tstop=:tstop").setEntity("description", (Object)desc).setLong("tstop", PackCst.STILL_VALID).list();
        return list.stream().collect(Collectors.toMap(cr -> cr.getConfiguration().getCategory(), cr -> cr));
    }

    public List<String> findAvailableConfigurationsForCategory(Description desc, String category) {
        return this.getSession().createQuery("select configName from Configuration where description=:desc and category=:cat").setEntity("desc", (Object)desc).setString("cat", category).list();
    }

    public GlobalConfiguration findGlobalConfiguration(Description desc, String name, int version) {
        if (version < 0) {
            return (GlobalConfiguration)this.getSession().createQuery("from GlobalConfiguration where description=:desc and name=:name and latest=true").setEntity("desc", (Object)desc).setString("name", name).uniqueResult();
        }
        return (GlobalConfiguration)this.getSession().createQuery("from GlobalConfiguration where description=:desc and name=:name and version=:version").setEntity("desc", (Object)desc).setString("name", name).setInteger("version", version).uniqueResult();
    }

    public GlobalConfiguration findGlobalConfigurationOrCreate(Description desc, String name, Map<String, Configuration> newConfigs) {
        List list = this.getSession().createQuery("from GlobalConfiguration where description=:desc and name=:name").setEntity("desc", (Object)desc).setString("name", name).list();
        int nver = 0;
        GlobalConfiguration latestGC = null;
        if (!list.isEmpty()) {
            nver = list.size();
            for (GlobalConfiguration gc : list) {
                if (gc.isLatest()) {
                    latestGC = gc;
                }
                boolean equal = true;
                for (Configuration c : gc.getConfigurations().values()) {
                    if (newConfigs.get(c.getCategory()).getId() == c.getId()) continue;
                    equal = false;
                    break;
                }
                if (!equal) continue;
                return gc;
            }
        }
        if (latestGC != null) {
            latestGC.setLatest(false);
        }
        GlobalConfiguration gc = new GlobalConfiguration(desc, name, nver);
        gc.setConfigurations(newConfigs);
        gc.setLatest(true);
        this.getSession().persist((Object)gc);
        return gc;
    }
}

