/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.hql.spi.ParameterTranslations;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.param.NamedParameterSpecification;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.param.PositionalParameterSpecification;
import org.hibernate.type.Type;

public class ParameterTranslationsImpl
implements ParameterTranslations {
    private final Map<String, ParameterInfo> namedParameters;
    private final ParameterInfo[] ordinalParameters;

    @Override
    public boolean supportsOrdinalParameterMetadata() {
        return true;
    }

    @Override
    public int getOrdinalParameterCount() {
        return this.ordinalParameters.length;
    }

    public ParameterInfo getOrdinalParameterInfo(int ordinalPosition) {
        return this.ordinalParameters[ordinalPosition - 1];
    }

    @Override
    public int getOrdinalParameterSqlLocation(int ordinalPosition) {
        return this.getOrdinalParameterInfo(ordinalPosition).getSqlLocations()[0];
    }

    @Override
    public Type getOrdinalParameterExpectedType(int ordinalPosition) {
        return this.getOrdinalParameterInfo(ordinalPosition).getExpectedType();
    }

    @Override
    public Set getNamedParameterNames() {
        return this.namedParameters.keySet();
    }

    public ParameterInfo getNamedParameterInfo(String name) {
        return this.namedParameters.get(name);
    }

    @Override
    public int[] getNamedParameterSqlLocations(String name) {
        return this.getNamedParameterInfo(name).getSqlLocations();
    }

    @Override
    public Type getNamedParameterExpectedType(String name) {
        return this.getNamedParameterInfo(name).getExpectedType();
    }

    public ParameterTranslationsImpl(List<ParameterSpecification> parameterSpecifications) {
        int size = parameterSpecifications.size();
        ArrayList<ParameterInfo> ordinalParameterList = new ArrayList<ParameterInfo>();
        class NamedParamTempHolder {
            String name;
            Type type;
            List<Integer> positions = new ArrayList<Integer>();

            NamedParamTempHolder() {
            }
        }
        HashMap<String, NamedParamTempHolder> namedParameterMap = new HashMap<String, NamedParamTempHolder>();
        for (int i = 0; i < size; ++i) {
            ParameterSpecification spec = parameterSpecifications.get(i);
            if (PositionalParameterSpecification.class.isInstance(spec)) {
                PositionalParameterSpecification ordinalSpec = (PositionalParameterSpecification)spec;
                ordinalParameterList.add(new ParameterInfo(i, ordinalSpec.getExpectedType()));
                continue;
            }
            if (!NamedParameterSpecification.class.isInstance(spec)) continue;
            NamedParameterSpecification namedSpec = (NamedParameterSpecification)spec;
            NamedParamTempHolder paramHolder = (NamedParamTempHolder)namedParameterMap.get(namedSpec.getName());
            if (paramHolder == null) {
                paramHolder = new NamedParamTempHolder();
                paramHolder.name = namedSpec.getName();
                paramHolder.type = namedSpec.getExpectedType();
                namedParameterMap.put(namedSpec.getName(), paramHolder);
            } else if (paramHolder.type == null && namedSpec.getExpectedType() != null) {
                paramHolder.type = namedSpec.getExpectedType();
            }
            paramHolder.positions.add(i);
        }
        this.ordinalParameters = ordinalParameterList.toArray(new ParameterInfo[ordinalParameterList.size()]);
        if (namedParameterMap.isEmpty()) {
            this.namedParameters = Collections.emptyMap();
        } else {
            HashMap<String, ParameterInfo> namedParametersBacking = new HashMap<String, ParameterInfo>(namedParameterMap.size());
            for (NamedParamTempHolder holder : namedParameterMap.values()) {
                namedParametersBacking.put(holder.name, new ParameterInfo(ArrayHelper.toIntArray(holder.positions), holder.type));
            }
            this.namedParameters = Collections.unmodifiableMap(namedParametersBacking);
        }
    }

    public static class ParameterInfo
    implements Serializable {
        private final int[] sqlLocations;
        private final Type expectedType;

        public ParameterInfo(int[] sqlPositions, Type expectedType) {
            this.sqlLocations = sqlPositions;
            this.expectedType = expectedType;
        }

        public ParameterInfo(int sqlPosition, Type expectedType) {
            this.sqlLocations = new int[]{sqlPosition};
            this.expectedType = expectedType;
        }

        public int[] getSqlLocations() {
            return this.sqlLocations;
        }

        public Type getExpectedType() {
            return this.expectedType;
        }
    }
}

