/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.data;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.utility.constants.FanState;
import org.lsst.ccs.subsystem.utility.constants.HeaterState;
import org.lsst.ccs.subsystem.utility.constants.ValveState;
import org.lsst.ccs.subsystem.utility.constants.VpcControlState;

@SkipEncoding
public class UtilTrunkState
implements Serializable {
    public static final String KEY = "UtilTrunkState";
    private int tickMillis;
    private final FanState[] fanState = new FanState[3];
    private final FanState[] fanBaseState = new FanState[3];
    private final double[] fanSpeed = new double[3];
    private final double[] deltaTemp = new double[3];
    private VpcControlState vpcState = VpcControlState.MANUAL;
    private final ValveState[] valveState = new ValveState[3];
    private final ValveState[] valveBaseState = new ValveState[3];
    private final double[] valvePosition = new double[3];
    private final HeaterState[] heaterState = new HeaterState[2];
    private final HeaterState[] heaterBaseState = new HeaterState[2];
    private final double[] heaterValue = new double[2];
    private static final long serialVersionUID = 6776368107598365551L;

    public UtilTrunkState() {
        Arrays.fill((Object[])this.fanState, (Object)FanState.OFFLINE);
        Arrays.fill((Object[])this.fanBaseState, (Object)FanState.SPEED);
        Arrays.fill((Object[])this.valveState, (Object)ValveState.OFFLINE);
        Arrays.fill((Object[])this.valveBaseState, (Object)ValveState.SHUT);
        Arrays.fill((Object[])this.heaterState, (Object)HeaterState.OFFLINE);
        Arrays.fill((Object[])this.heaterBaseState, (Object)HeaterState.OFF);
    }

    public void setTickMillis(int value) {
        this.tickMillis = value;
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setFanState(int fan, FanState state) {
        this.fanState[fan] = state;
    }

    public FanState getFanState(int fan) {
        return this.fanState[fan];
    }

    public void setFanBaseState(int fan, FanState state) {
        this.fanBaseState[fan] = state;
    }

    public FanState getFanBaseState(int fan) {
        return this.fanBaseState[fan];
    }

    public void setFanSpeed(int fan, double speed) {
        this.fanSpeed[fan] = speed;
    }

    public double getFanSpeed(int fan) {
        return this.fanSpeed[fan];
    }

    public void setVpcState(VpcControlState state) {
        this.vpcState = state;
    }

    public VpcControlState getVpcState() {
        return this.vpcState;
    }

    public void setValveState(int valve, ValveState state) {
        this.valveState[valve] = state;
    }

    public ValveState getValveState(int valve) {
        return this.valveState[valve];
    }

    public void setValveBaseState(int valve, ValveState state) {
        this.valveBaseState[valve] = state;
    }

    public ValveState getValveBaseState(int valve) {
        return this.valveBaseState[valve];
    }

    public void setValvePosition(int valve, double position) {
        this.valvePosition[valve] = position;
    }

    public double getValvePosition(int valve) {
        return this.valvePosition[valve];
    }

    public void setDeltaTemp(int fan, double temp) {
        this.deltaTemp[fan] = temp;
    }

    public double getDeltaTemp(int fan) {
        return this.deltaTemp[fan];
    }

    public void setHeaterState(int htr, HeaterState state) {
        this.heaterState[htr] = state;
    }

    public HeaterState getHeaterState(int htr) {
        return this.heaterState[htr];
    }

    public void setHeaterBaseState(int htr, HeaterState state) {
        this.heaterBaseState[htr] = state;
    }

    public HeaterState getHeaterBaseState(int htr) {
        return this.heaterBaseState[htr];
    }

    public void setHeaterValue(int htr, double value) {
        this.heaterValue[htr] = value;
    }

    public double getHeaterValue(int htr) {
        return this.heaterValue[htr];
    }
}

