package org.lsst.ccs.subsystem.utility.data;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.SkipEncoding;

/**
 *  Contains the state of the utility subsystem
 *
 *  @author Owen Saxton
 */
@SkipEncoding
public class UtilityState implements Serializable {
    
    public static final String KEY = "UtilityState";
    public static final int OPS_CTRL_OFF = 0;      // Op state - fan control off
    public static final int OPS_CTRL_MANUAL = 1;   // Op state - fan control manual
    public static final int OPS_CTRL_AUTO = 2;     // Op state - fan control auto

    private final int tickMillis;        // Data status update period (ms)
    private final int opState;           // Operation state
    private final double coolTemp;       // Cooling temperature
    private final double dutyCycle;      // Cooling fan duty cycle
    private final double loopGain;       // Control loop gain
    private final double loopTimeConst;  // Control loop time constant
    
    public UtilityState() {
        this(0, 0, 0.0, 0.0, 0.0, 0.0);
    }
    
    public UtilityState(int tickMillis, int opState, double coolTemp, double dutyCycle,
                        double loopGain, double loopTimeConst) {
        this.tickMillis = tickMillis;
        this.opState = opState;
        this.coolTemp = coolTemp;
        this.dutyCycle = dutyCycle;
        this.loopGain = loopGain;
        this.loopTimeConst = loopTimeConst;
    }
    
    public int getTickMillis() {
        return tickMillis;
    }

    public int getOpState() {
        return opState;
    }

    public double getCoolTemp() {
        return coolTemp;
    }

    public double getDutyCycle() {
        return dutyCycle;
    }

    public double getLoopGain() {
        return loopGain;
    }

    public double getLoopTimeConst() {
        return loopTimeConst;
    }

    private static final long serialVersionUID = 6080691470240882194L;
}
