package org.lsst.ccs.subsystem.utility.data;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.utility.constants.FanState;
import org.lsst.ccs.subsystem.utility.constants.UTTestFans;
import org.lsst.ccs.subsystem.utility.constants.UTTestSwitches;
import org.lsst.ccs.subsystem.utility.constants.UTTestValves;
import org.lsst.ccs.subsystem.utility.constants.SwitchState;
import org.lsst.ccs.subsystem.utility.constants.ValveState;

/**
 *  Contains the state of the purge test subsystem
 *
 *  @author Owen Saxton
 */
@SkipEncoding
public class UTTestState implements Serializable {
    
    public static final String KEY = "UTTestState";

    private int tickMillis;        // Data status update period (ms)
    private final SwitchState[] switchState = new SwitchState[UTTestSwitches.NUM_PWR_SWITCHES];  // Switch state array
    private final SwitchState[] switchBaseState = new SwitchState[UTTestSwitches.NUM_PWR_SWITCHES];  // Switch state array
    private final FanState[] fanState = new FanState[UTTestFans.NUM_FANS];
    private final FanState[] fanBaseState = new FanState[UTTestFans.NUM_FANS];
    private final double[] fanSpeed = new double[UTTestFans.NUM_FANS];
    private final double[] deltaTemp = new double[UTTestFans.NUM_FANS];
    private final ValveState[] valveState = new ValveState[UTTestValves.NUM_VALVES];
    private final ValveState[] valveBaseState = new ValveState[UTTestValves.NUM_VALVES];
    private final double[] valvePosition = new double[UTTestValves.NUM_VALVES];
    
    public UTTestState() {
        Arrays.fill(switchState, SwitchState.OFFLINE);
        Arrays.fill(switchBaseState, SwitchState.OFF);
        Arrays.fill(fanState, FanState.OFFLINE);
        Arrays.fill(fanBaseState, FanState.SPEED);
        Arrays.fill(valveState, ValveState.OFFLINE);
        Arrays.fill(valveBaseState, ValveState.SHUT);
    }
    
    public void setTickMillis(int value) {
        tickMillis = value;
    }

    public int getTickMillis() {
        return tickMillis;
    }

    public void setSwitchState(int sw, SwitchState state) {
        switchState[sw] = state;
    }

    public SwitchState getSwitchState(int sw) {
        return switchState[sw];
    }

    public void setSwitchBaseState(int sw, SwitchState state) {
        switchBaseState[sw] = state;
    }

    public SwitchState getSwitchBaseState(int sw) {
        return switchBaseState[sw];
    }

    public void setFanState(int fan, FanState state) {
        fanState[fan] = state;
    }

    public FanState getFanState(int fan) {
        return fanState[fan];
    }

    public void setFanBaseState(int fan, FanState state) {
        fanBaseState[fan] = state;
    }

    public FanState getFanBaseState(int fan) {
        return fanBaseState[fan];
    }

    public void setFanSpeed(int fan, double speed) {
        fanSpeed[fan] = speed;
    }

    public double getFanSpeed(int fan) {
        return fanSpeed[fan];
    }

    public void setValveState(int valve, ValveState state) {
        valveState[valve] = state;
    }

    public ValveState getValveState(int valve) {
        return valveState[valve];
    }

    public void setValveBaseState(int valve, ValveState state) {
        valveBaseState[valve] = state;
    }

    public ValveState getValveBaseState(int valve) {
        return valveBaseState[valve];
    }

    public void setValvePosition(int valve, double position) {
        valvePosition[valve] = position;
    }

    public double getValvePosition(int valve) {
        return valvePosition[valve];
    }

    public void setDeltaTemp(int fan, double temp) {
        deltaTemp[fan] = temp;
    }

    public double getDeltaTemp(int fan) {
        return deltaTemp[fan];
    }

    private static final long serialVersionUID = 4762741558282923122L;
}
