package org.lsst.ccs.subsystem.utility.constants;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Purge test switch definitions.
 *
 * @author The CCS team
 */
public class UTTestSwitches {

    public static final int
        SW_BFR_48V_PDU   = 0,
        SW_BFR_24V_PDU   = 1,
        SW_PDU_48V_MAIN  = 2,
        SW_PDU_24V_MAIN  = 3,
        SW_PDU_ELEX      = 4,
        NUM_PWR_SWITCHES = 5,
        SW_PDU_UT_FAN    = 5,
        NUM_SWITCHES     = 6;

    public static final String
        BFR_48V_PDU  = "Bfr48VPdu",
        BFR_24V_PDU  = "Bfr24VPdu",
        PDU_48V_MAIN = "Pdu48VMain",
        PDU_24V_MAIN = "Pdu24VMain",
        PDU_ELEX     = "PduElex";

    public static final int
        DEVC_BFR      = 0,
        DEVC_PDU_24V  = 1,
        DEVC_PDU_48V  = 2,
        NUM_DEVICES   = 3;

    public static final Map<String, Integer> switchNameToId = new LinkedHashMap<>();
    static {
        switchNameToId.put(BFR_24V_PDU, UTTestSwitches.SW_BFR_24V_PDU);
        switchNameToId.put(BFR_48V_PDU, UTTestSwitches.SW_BFR_48V_PDU);
        switchNameToId.put(PDU_48V_MAIN, UTTestSwitches.SW_PDU_48V_MAIN);
        switchNameToId.put(PDU_24V_MAIN, UTTestSwitches.SW_PDU_24V_MAIN);
        switchNameToId.put(PDU_ELEX, UTTestSwitches.SW_PDU_ELEX);
    }

    public static final Map<Integer, String> switchIdToName = new LinkedHashMap<>();
    static {
        for (Map.Entry entry : switchNameToId.entrySet()) {
            switchIdToName.put((Integer)entry.getValue(), (String)entry.getKey());
        }
    }

}
