package org.lsst.ccs.subsystem.utility.constants;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Utility trunk test fan definitions.
 *
 * @author The CCS team
 */
public class UTTestFans {

    public static final String
        FAN_UT  = "UtFan";

    public static final int
        FAN_UT_ID  = 0,
        NUM_FANS = 1;

    public static final Map<Integer, Integer> fanSwitchMap = new LinkedHashMap<>();
    static {
        fanSwitchMap.put(FAN_UT_ID, UTTestSwitches.SW_PDU_UT_FAN);
    }

    public static final Map<String, Integer> fanNameToId = new LinkedHashMap<>();
    static {
        fanNameToId.put(FAN_UT, FAN_UT_ID);
    }

    public static final Map<Integer, String> fanIdToName = new LinkedHashMap<>();
    static {
        for (Map.Entry entry : fanNameToId.entrySet()) {
            fanIdToName.put((Integer)entry.getValue(), (String)entry.getKey());
        }
    }

    public static final boolean[] hasTempState = new boolean[NUM_FANS];
    static {
        hasTempState[FAN_UT_ID] = true;
    }

}
