package org.lsst.ccs.subsystem.utility.constants;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Purge test heater definitions.
 *
 * @author The CCS team
 */
public class PurgeTestHeaters {

    public static final String
        HEATER_VPC1 = "VpcHeater1",
        HEATER_VPC2 = "VpcHeater2",
        HEATER_SIM = "SimHeater";

    public static final int
        HEATER_VPC1_ID = 0,
        HEATER_VPC2_ID = 1,
        NUM_VPC_HEATERS = 2,
        HEATER_SIM_ID = 2,
        NUM_HEATERS = 3;

    public static final Map<Integer, Integer> heaterSwitchMap = new LinkedHashMap<>();
    static {
        heaterSwitchMap.put(HEATER_VPC1_ID, PurgeTestSwitches.SW_BFR_HEATER_1);
        heaterSwitchMap.put(HEATER_VPC2_ID, PurgeTestSwitches.SW_BFR_HEATER_2);
        heaterSwitchMap.put(HEATER_SIM_ID, PurgeTestSwitches.SW_BFR_HTR_SIM);
    }

    public static final Map<String, Integer> heaterNameToId = new LinkedHashMap<>();
    static {
        heaterNameToId.put(HEATER_VPC1, HEATER_VPC1_ID);
        heaterNameToId.put(HEATER_VPC2, HEATER_VPC2_ID);
        heaterNameToId.put(HEATER_SIM, HEATER_SIM_ID);
    }

    public static final Map<Integer, String> heaterIdToName = new LinkedHashMap<>();
    static {
        for (Map.Entry entry : heaterNameToId.entrySet()) {
            heaterIdToName.put((Integer)entry.getValue(), (String)entry.getKey());
        }
    }

    public static final boolean[] hasAutoState = new boolean[NUM_HEATERS];
    static {
        hasAutoState[HEATER_VPC1_ID] = true;
        hasAutoState[HEATER_VPC2_ID] = true;
        hasAutoState[HEATER_SIM_ID] = false;
    }
}
