package org.lsst.ccs.subsystem.utility.data;

import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.utility.constants.ConditionState;
import org.lsst.ccs.subsystem.utility.constants.LatchState;
import org.lsst.ccs.subsystem.utility.constants.MpmConditions;
import org.lsst.ccs.subsystem.utility.constants.MpmLatches;
import org.lsst.ccs.subsystem.utility.constants.MpmLimits;
import org.lsst.ccs.subsystem.utility.constants.MpmPlcs;
import org.lsst.ccs.subsystem.utility.constants.MpmSwitches;
import org.lsst.ccs.subsystem.utility.constants.PLCState;
import org.lsst.ccs.subsystem.utility.constants.SwitchState;
import java.io.Serializable;
import java.util.Arrays;

/**
 *  Contains the state of the protection subsystem
 *
 *  @author Owen Saxton
 */
@SkipEncoding
public class MpmSysState implements Serializable {
    
    public static final String KEY = "MPMState";
    private int tickMillis;           // Data status update period (ms)
    private final PLCState[] plcState = new PLCState[MpmPlcs.NUM_PLCS];  // PLC state array
    private final SwitchState[] switchState = new SwitchState[MpmSwitches.NUM_SWITCHES];  // Switch state array
    private final LatchState[] latchState = new LatchState[MpmLatches.NUM_LATCHES];  // Latched PLC conditions array
    private final ConditionState[] conditionState = new ConditionState[MpmConditions.NUM_CONDITIONS];  // PLC conditions array
    private final int[] tempLimit = new int[MpmLimits.NUM_LIMITS];  // Cryo and cold plate temperature limits

    public MpmSysState() {
        Arrays.fill(plcState, PLCState.ALIVE);
        Arrays.fill(switchState, SwitchState.OFFLINE);
        Arrays.fill(latchState, LatchState.OFFLINE);
        Arrays.fill(conditionState, ConditionState.OFF);
        Arrays.fill(tempLimit, Integer.MAX_VALUE);
    }

    public void setTickMillis(int value) {
        tickMillis = value;
    }

    public int getTickMillis() {
        return tickMillis;
    }

    public void setPlcState(int plc, PLCState value) {
        plcState[plc] = value;
    }

    public PLCState getPlcState(int plc) {
        return plcState[plc];
    }

    public void setSwitchState(int sw, SwitchState state) {
        switchState[sw] = state;
    }

    public SwitchState getSwitchState(int sw) {
        return switchState[sw];
    }

    public void setLatch(int latch, LatchState state) {
        latchState[latch] = state;
    }

    public LatchState getLatch(int latch) {
        return latchState[latch];
    }

    public void setCondition(int cond, ConditionState state) {
        conditionState[cond] = state;
    }

    public ConditionState getCondition(int cond) {
        return conditionState[cond];
    }

    public void setLimit(int limit, int value) {
        tempLimit[limit] = value;
    }

    public int getLimit(int limit) {
        return tempLimit[limit];
    }

    private static final long serialVersionUID = -5524875121139066984L;
}
