package org.lsst.ccs.subsystem.utility.constants;

import org.lsst.ccs.bus.data.Alert;

/**
 * Utility Trunk Alerts.
 * 
 * @author The LSST CCS Team
 */
public enum UtilTrunkAlert {

    /**
     * Utility trunk has warning or alarm conditions
     */
    OVER_TEMPERATURE("OverTemperature", "Over-temperature");
        
    private final String id, description;
    
    UtilTrunkAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getId() {
        return id;
    }
    
    public String getId(String item) {
        return item + id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public String getDescription(String item) {
        return item + " " + description;
    }
    
    public Alert newAlert() {
        return new Alert(id, description);
    }
    
    public Alert newAlert(String item) {
        return new Alert(getId(item), getDescription(item));
    }
    
}
