package org.lsst.ccs.subsystem.utility.constants;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

/**
 * Utility trunk valve definitions.
 *
 * @author The CCS team
 */
public class UtilTrunkValves {

    public static final String
        VALVE_UT  = "UtValve",
        VALVE_VPC = "VpcValve",
        VALVE_MPC = "MpcValve";

    public static final int
        VALVE_UT_ID  = 0,
        VALVE_VPC_ID = 1,
        VALVE_MPC_ID = 2,
        NUM_VALVES = 3;

    private static final Map<String, Integer> valveNameToId = new LinkedHashMap<>();
    static {
        valveNameToId.put(VALVE_UT, VALVE_UT_ID);
        valveNameToId.put(VALVE_VPC, VALVE_VPC_ID);
        valveNameToId.put(VALVE_MPC, VALVE_MPC_ID);
    }

    private static final Map<Integer, String> valveIdToName = new LinkedHashMap<>();
    static {
        for (Map.Entry entry : valveNameToId.entrySet()) {
            valveIdToName.put((Integer)entry.getValue(), (String)entry.getKey());
        }
    }

    private static final boolean[] hasTempState = new boolean[NUM_VALVES];
    static {
        hasTempState[VALVE_UT_ID] = false;
        hasTempState[VALVE_VPC_ID] = false;
        hasTempState[VALVE_MPC_ID] = false;
    }

    /**
     *  Gets the list of valve names.
     * 
     *  @return  The list of names
     */
    public static List<String> getNames()
    {
        return new ArrayList<>(valveNameToId.keySet());
    }

    /**
     *  Gets a valve name from its ID.
     * 
     *  @param  id  The valve id
     *  @return  The valve name
     */
    public static String getName(int id)
    {
        return valveIdToName.get(id);
    }

    /**
     *  Gets a valve ID from its name.
     * 
     *  @param  name  The valve name
     *  @return  The valve ID
     *  @throws  UtilityException
     */
    public static int getId(String name) throws UtilityException
    {
        Integer id = valveNameToId.get(name);
        if (id == null) {
            throw new UtilityException("Invalid valve name: " + name);
        }
        return id;
    }

}
