package org.lsst.ccs.subsystem.utility.constants;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Purge test fan definitions.
 *
 * @author The CCS team
 */
public class PurgeTestFans {

    public static final String
        FAN_MPC = "MpcFan",
        FAN_VPC = "VpcFan",
        FAN_UT  = "UtFan";

    public static final int
        FAN_MPC_ID = 0,
        FAN_VPC_ID = 1,
        FAN_UT_ID  = 2,
        NUM_FANS = 3;

    public static final Map<Integer, Integer> fanSwitchMap = new LinkedHashMap<>();
    static {
        fanSwitchMap.put(FAN_MPC_ID, PurgeTestSwitches.SW_PDU_MPC_FAN);
        fanSwitchMap.put(FAN_VPC_ID, PurgeTestSwitches.SW_PDU_VPC_FAN);
        fanSwitchMap.put(FAN_UT_ID, PurgeTestSwitches.SW_PDU_UT_FAN);
    }

    public static final Map<String, Integer> fanNameToId = new LinkedHashMap<>();
    static {
        fanNameToId.put(FAN_MPC, FAN_MPC_ID);
        fanNameToId.put(FAN_VPC, FAN_VPC_ID);
        fanNameToId.put(FAN_UT, FAN_UT_ID);
    }

    public static final Map<Integer, String> fanIdToName = new LinkedHashMap<>();
    static {
        for (Map.Entry entry : fanNameToId.entrySet()) {
            fanIdToName.put((Integer)entry.getValue(), (String)entry.getKey());
        }
    }

    public static final boolean[] hasTempState = new boolean[NUM_FANS];
    static {
        hasTempState[FAN_MPC_ID] = true;
        hasTempState[FAN_VPC_ID] = false;
        hasTempState[FAN_UT_ID] = true;
    }

}
