package org.lsst.ccs.subsystem.utility.constants;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Purge test valve definitions.
 *
 * @author The CCS team
 */
public class UTPurgeValves {

    public static final String
        VALVE_UT  = "UtValve";

    public static final int
        VALVE_UT_ID  = 0,
        NUM_VALVES = 1;

    public static final Map<String, Integer> valveNameToId = new LinkedHashMap<>();
    static {
        valveNameToId.put(VALVE_UT, VALVE_UT_ID);
    }

    public static final Map<Integer, String> valveIdToName = new LinkedHashMap<>();
    static {
        for (Map.Entry entry : valveNameToId.entrySet()) {
            valveIdToName.put((Integer)entry.getValue(), (String)entry.getKey());
        }
    }

    public static final boolean[] hasTempState = new boolean[NUM_VALVES];
    static {
        hasTempState[VALVE_UT_ID] = false;
    }

}
