package org.lsst.ccs.subsystem.utility.data;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.subsystem.utility.constants.FanState;
import org.lsst.ccs.subsystem.utility.constants.HeaterState;
import org.lsst.ccs.subsystem.utility.constants.PurgeTestFans;
import org.lsst.ccs.subsystem.utility.constants.PurgeTestHeaters;
import org.lsst.ccs.subsystem.utility.constants.PurgeTestSwitches;
import org.lsst.ccs.subsystem.utility.constants.PurgeTestValves;
import org.lsst.ccs.subsystem.utility.constants.SwitchState;
import org.lsst.ccs.subsystem.utility.constants.ValveState;
import org.lsst.ccs.subsystem.utility.constants.VpcControlState;

/**
 *  Contains the state of the purge test subsystem
 *
 *  @author Owen Saxton
 */
public class PurgeTestState implements Serializable {
    
    public static final String KEY = "PurgeTestState";

    private int tickMillis;        // Data status update period (ms)
    private final SwitchState[] switchState = new SwitchState[PurgeTestSwitches.NUM_PWR_SWITCHES];  // Switch state array
    private final SwitchState[] switchBaseState = new SwitchState[PurgeTestSwitches.NUM_PWR_SWITCHES];  // Switch state array
    private final FanState[] fanState = new FanState[PurgeTestFans.NUM_FANS];
    private final FanState[] fanBaseState = new FanState[PurgeTestFans.NUM_FANS];
    private final double[] fanSpeed = new double[PurgeTestFans.NUM_FANS];
    private final double[] deltaTemp = new double[PurgeTestFans.NUM_FANS];
    private VpcControlState vpcState = VpcControlState.MANUAL;
    private final ValveState[] valveState = new ValveState[PurgeTestValves.NUM_VALVES];
    private final ValveState[] valveBaseState = new ValveState[PurgeTestValves.NUM_VALVES];
    private final double[] valvePosition = new double[PurgeTestValves.NUM_VALVES];
    private final HeaterState[] heaterState = new HeaterState[PurgeTestHeaters.NUM_HEATERS];
    private final HeaterState[] heaterBaseState = new HeaterState[PurgeTestHeaters.NUM_HEATERS];
    private final double[] heaterValue = new double[PurgeTestHeaters.NUM_HEATERS];
    
    public PurgeTestState() {
        Arrays.fill(switchState, SwitchState.OFFLINE);
        Arrays.fill(switchBaseState, SwitchState.OFF);
        Arrays.fill(fanState, FanState.OFFLINE);
        Arrays.fill(fanBaseState, FanState.SPEED);
        Arrays.fill(valveState, ValveState.OFFLINE);
        Arrays.fill(valveBaseState, ValveState.SHUT);
        Arrays.fill(heaterState, HeaterState.OFFLINE);
        Arrays.fill(heaterBaseState, HeaterState.OFF);
    }
    
    public void setTickMillis(int value) {
        tickMillis = value;
    }

    public int getTickMillis() {
        return tickMillis;
    }

    public void setSwitchState(int sw, SwitchState state) {
        switchState[sw] = state;
    }

    public SwitchState getSwitchState(int sw) {
        return switchState[sw];
    }

    public void setSwitchBaseState(int sw, SwitchState state) {
        switchBaseState[sw] = state;
    }

    public SwitchState getSwitchBaseState(int sw) {
        return switchBaseState[sw];
    }

    public void setFanState(int fan, FanState state) {
        fanState[fan] = state;
    }

    public FanState getFanState(int fan) {
        return fanState[fan];
    }

    public void setFanBaseState(int fan, FanState state) {
        fanBaseState[fan] = state;
    }

    public FanState getFanBaseState(int fan) {
        return fanBaseState[fan];
    }

    public void setFanSpeed(int fan, double speed) {
        fanSpeed[fan] = speed;
    }

    public double getFanSpeed(int fan) {
        return fanSpeed[fan];
    }

    public void setVpcState(VpcControlState state) {
        vpcState = state;
    }

    public VpcControlState getVpcState() {
        return vpcState;
    }

    public void setValveState(int valve, ValveState state) {
        valveState[valve] = state;
    }

    public ValveState getValveState(int valve) {
        return valveState[valve];
    }

    public void setValveBaseState(int valve, ValveState state) {
        valveBaseState[valve] = state;
    }

    public ValveState getValveBaseState(int valve) {
        return valveBaseState[valve];
    }

    public void setValvePosition(int valve, double position) {
        valvePosition[valve] = position;
    }

    public double getValvePosition(int valve) {
        return valvePosition[valve];
    }

    public void setDeltaTemp(int fan, double temp) {
        deltaTemp[fan] = temp;
    }

    public double getDeltaTemp(int fan) {
        return deltaTemp[fan];
    }

    public void setHeaterState(int htr, HeaterState state) {
        heaterState[htr] = state;
    }

    public HeaterState getHeaterState(int htr) {
        return heaterState[htr];
    }

    public void setHeaterBaseState(int htr, HeaterState state) {
        heaterBaseState[htr] = state;
    }

    public HeaterState getHeaterBaseState(int htr) {
        return heaterBaseState[htr];
    }

    public void setHeaterValue(int htr, double value) {
        heaterValue[htr] = value;
    }

    public double getHeaterValue(int htr) {
        return heaterValue[htr];
    }

    private static final long serialVersionUID = -4748426867099312891L;
}
