package org.lsst.ccs.subsystem.utility.constants;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Purge test valve definitions.
 *
 * @author The CCS team
 */
public class PurgeTestValves {

    public static final String
        VALVE_VPC = "VpcValve",
        VALVE_UT  = "UtValve";

    public static final int
        VALVE_VPC_ID = 0,
        VALVE_UT_ID  = 1,
        NUM_VALVES = 2;

    public static final Map<String, Integer> valveNameToId = new LinkedHashMap<>();
    static {
        valveNameToId.put(VALVE_VPC, VALVE_VPC_ID);
        valveNameToId.put(VALVE_UT, VALVE_UT_ID);
    }

    public static final Map<Integer, String> valveIdToName = new LinkedHashMap<>();
    static {
        for (Map.Entry entry : valveNameToId.entrySet()) {
            valveIdToName.put((Integer)entry.getValue(), (String)entry.getKey());
        }
    }

    public static final boolean[] hasTempState = new boolean[NUM_VALVES];
    static {
        hasTempState[VALVE_VPC_ID] = true;
        hasTempState[VALVE_UT_ID] = false;
    }

}
